/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;
import org.eclipse.vjet.dsf.js.dbgp.BreakCommand;
import org.eclipse.vjet.dsf.js.dbgp.BreakPoint;
import org.eclipse.vjet.dsf.js.dbgp.ContextGetCommand;
import org.eclipse.vjet.dsf.js.dbgp.ContextNamesCommand;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPStackManager;
import org.eclipse.vjet.dsf.js.dbgp.EvalCommand;
import org.eclipse.vjet.dsf.js.dbgp.FeatureGetCommand;
import org.eclipse.vjet.dsf.js.dbgp.FeatureSetCommand;
import org.eclipse.vjet.dsf.js.dbgp.GetBreakPointCommand;
import org.eclipse.vjet.dsf.js.dbgp.ISourceProvider;
import org.eclipse.vjet.dsf.js.dbgp.PropertyGetCommand;
import org.eclipse.vjet.dsf.js.dbgp.PropertySetCommand;
import org.eclipse.vjet.dsf.js.dbgp.RemoveBreakPointCommand;
import org.eclipse.vjet.dsf.js.dbgp.RunCommand;
import org.eclipse.vjet.dsf.js.dbgp.SetBreakPointCommand;
import org.eclipse.vjet.dsf.js.dbgp.SourceCommand;
import org.eclipse.vjet.dsf.js.dbgp.SourceListCommand;
import org.eclipse.vjet.dsf.js.dbgp.SourceProvider;
import org.eclipse.vjet.dsf.js.dbgp.StackDepthCommand;
import org.eclipse.vjet.dsf.js.dbgp.StackGetCommand;
import org.eclipse.vjet.dsf.js.dbgp.StdErrCommand;
import org.eclipse.vjet.dsf.js.dbgp.StdInCommand;
import org.eclipse.vjet.dsf.js.dbgp.StdOutCommand;
import org.eclipse.vjet.dsf.js.dbgp.StepIntoCommand;
import org.eclipse.vjet.dsf.js.dbgp.StepOutCommand;
import org.eclipse.vjet.dsf.js.dbgp.StepOverCommand;
import org.eclipse.vjet.dsf.js.dbgp.StopCommand;
import org.eclipse.vjet.dsf.js.dbgp.UpdateBreakPointCommand;
import org.eclipse.vjet.dsf.js.dbgp.file.IVFile;
import org.eclipse.vjet.dsf.js.dbgp.file.IVFileManager;
import org.eclipse.vjet.dsf.js.dbgp.file.VFileManager;
import org.eclipse.vjet.dsf.js.dbgp.file.VFileSourceProvider;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.NativeJavaArray;
import org.mozilla.mod.javascript.NativeJavaClass;
import org.mozilla.mod.javascript.NativeJavaObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.Undefined;
import org.mozilla.mod.javascript.UniqueTag;
import org.mozilla.mod.javascript.debug.DebugFrame;
import org.mozilla.mod.javascript.debug.DebuggableScript;
import org.mozilla.mod.javascript.debug.Debugger;

public class DBGPDebugger
extends Thread
implements Debugger,
Observer {
    private Socket m_socket;
    private PrintStream m_out;
    private Map<String, Command> m_strategies = new HashMap<String, Command>();
    String m_runTransctionId;
    DBGPStackManager m_stackmanager;
    public boolean isInited;
    private boolean m_sessionEstablished;
    private String m_sessionId;
    private static int s_count = 0;
    private IVFileManager m_vFileManager = new VFileManager();
    private ISourceProvider[] m_sourceProviders;
    private SourceProvider m_sourceProvider = new SourceProvider();
    private Context m_ctx;
    private Scriptable m_scope;
    WeakHashMap<ScriptableObject, String> cache = new WeakHashMap();

    void printResponse(String response) {
        this.m_out.print(response.length());
        this.m_out.write(0);
        this.m_out.print(response);
        this.m_out.write(0);
        this.m_out.flush();
    }

    public void setContext(Context cx) {
        DBGPStackManager manager = DBGPStackManager.getManager(cx);
        manager.setDebugger(this);
        this.m_stackmanager = manager;
    }

    public DBGPDebugger(Socket socket, String file, String sessionId, Context ct) throws IOException {
        this.m_sessionId = sessionId;
        this.createDebugger(socket, ct);
    }

    public DBGPDebugger(Socket socket, Context ct) throws IOException {
        this.createDebugger(socket, ct);
    }

    private void createDebugger(Socket socket, Context ct) throws IOException {
        this.m_socket = socket;
        this.m_ctx = ct;
        this.m_stackmanager = DBGPStackManager.getManager(ct);
        this.m_stackmanager.suspend();
        this.m_out = new PrintStream(socket.getOutputStream());
        this.m_stackmanager.setDebugger(this);
        this.m_strategies.put("feature_get", new FeatureGetCommand(this));
        this.m_strategies.put("feature_set", new FeatureSetCommand(this));
        this.m_strategies.put("stdin", new StdInCommand(this));
        this.m_strategies.put("stdout", new StdOutCommand(this));
        this.m_strategies.put("stderr", new StdErrCommand(this));
        this.m_strategies.put("run", new RunCommand(this));
        this.m_strategies.put("context_names", new ContextNamesCommand(this));
        this.m_strategies.put("stop", new StopCommand(this));
        this.m_strategies.put("step_over", new StepOverCommand(this));
        this.m_strategies.put("step_into", new StepIntoCommand(this));
        this.m_strategies.put("step_out", new StepOutCommand(this));
        this.m_strategies.put("breakpoint_get", new GetBreakPointCommand(this));
        this.m_strategies.put("breakpoint_set", new SetBreakPointCommand(this));
        this.m_strategies.put("breakpoint_remove", new RemoveBreakPointCommand(this));
        this.m_strategies.put("breakpoint_update", new UpdateBreakPointCommand(this));
        this.m_strategies.put("context_get", new ContextGetCommand(this));
        this.m_strategies.put("property_set", new PropertySetCommand(this));
        this.m_strategies.put("eval", new EvalCommand(this));
        this.m_strategies.put("property_get", new PropertyGetCommand(this));
        this.m_strategies.put("break", new BreakCommand(this));
        this.m_strategies.put("stack_depth", new StackDepthCommand(this));
        this.m_strategies.put("stack_get", new StackGetCommand(this));
        this.m_strategies.put("source", new SourceCommand(this, this.getSourceProviders()));
        this.m_strategies.put("source_list", new SourceListCommand(this, this.getSourceProviders()));
        this.m_out.flush();
        this.isInited = true;
    }

    private ISourceProvider[] getSourceProviders() {
        if (this.m_sourceProviders == null) {
            VFileSourceProvider vFileSourceProvider = new VFileSourceProvider(this.m_vFileManager);
            this.m_sourceProviders = new ISourceProvider[]{vFileSourceProvider, this.m_sourceProvider};
        }
        return this.m_sourceProviders;
    }

    protected void printProperty(String id, String fullName, Object value, StringBuffer properties, int level, boolean addChilds) {
        String vlEncoded;
        boolean hasChilds = false;
        int numC = 0;
        String name_of_object_class = "";
        String data_type = "Object";
        if (value instanceof Function) {
            data_type = "function";
        } else if (value instanceof NativeJavaObject) {
            data_type = "javaobject";
        } else if (value instanceof NativeJavaClass) {
            data_type = "javaclass";
        } else if (value instanceof NativeJavaArray) {
            data_type = "javaarray";
        }
        if (value instanceof Scriptable) {
            String nv;
            hasChilds = true;
            StringBuffer stringBuffer = new StringBuffer();
            Scriptable p = (Scriptable)value;
            Object[] ids = p.getIds();
            numC = ids.length;
            name_of_object_class = nv = p.getClassName();
            if (p instanceof NativeJavaObject) {
                String string;
                NativeJavaObject obj = (NativeJavaObject)p;
                Object unwrap = obj.unwrap();
                if (unwrap instanceof Class) {
                    nv = ((Class)unwrap).getName();
                } else if (unwrap.getClass().isArray()) {
                    string = unwrap.getClass().getName();
                    int len = Array.getLength(unwrap);
                    int q = string.indexOf(91);
                    if (q != -1) {
                        string = string.substring(0, q);
                    }
                    int q1 = string.indexOf(93);
                    nv = String.valueOf(string) + "[" + len + "]";
                    if (q1 != -1) {
                        nv = String.valueOf(nv) + string.substring(q1);
                    }
                } else if (unwrap instanceof String) {
                    nv = unwrap.toString();
                } else {
                    string = unwrap.toString();
                    nv = String.valueOf(unwrap.getClass().getName()) + "(" + string + ")";
                }
            }
            stringBuffer.append(Base64Helper.encodeString(nv));
            if (addChilds) {
                int a = 0;
                while (a < ids.length) {
                    Object pvalue = ids[a] instanceof Integer ? p.get(((Integer)ids[a]).intValue(), p) : (ids[a] instanceof String ? p.get(ids[a].toString(), p) : null);
                    this.printProperty(ids[a].toString(), String.valueOf(fullName) + "." + ids[a], pvalue, stringBuffer, level + 1, false);
                    ++a;
                }
            }
            vlEncoded = stringBuffer.toString();
        } else {
            vlEncoded = !(value instanceof Undefined) ? (value == UniqueTag.NOT_FOUND ? "" : Base64Helper.encodeString(value != null ? value.toString() : "null")) : Base64Helper.encodeString("Undefined");
            if (value != null) {
                name_of_object_class = value.getClass().getName();
            }
        }
        properties.append("<property\r\n    name=\"" + id + "\"\r\n" + "    fullname=\"" + fullName + "\"\r\n" + "    type=\"" + data_type + "\"\r\n" + "    classname=\"" + name_of_object_class + "\"\r\n" + "    constant=\"0\"\r\n" + "    children=\"" + (hasChilds ? 1 : 0) + "\"\r\n" + "    encoding=\"base64\"\r\n" + "    numchildren=\"" + numC + "\">\r\n" + vlEncoded + "</property>\r\n");
    }

    @Override
    public void run() {
        try {
            DataInputStream ds = new DataInputStream(this.m_socket.getInputStream());
            StringBuffer buf = new StringBuffer();
            while (ds.available() >= 0) {
                int c = ds.read();
                if (c < 0) break;
                if (c < 32) {
                    String s = buf.toString();
                    int indexOf = s.indexOf(32);
                    if (indexOf != -1) {
                        String commandId = buf.substring(0, indexOf);
                        Command object = this.m_strategies.get(commandId);
                        if (object == null) {
                            System.err.println(commandId);
                            continue;
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        String result = buf.substring(indexOf + 1);
                        String[] split = result.split(" ");
                        try {
                            int a = 0;
                            while (a < split.length) {
                                options.put(split[a], split[++a]);
                                ++a;
                            }
                        }
                        catch (Exception exception) {}
                        object.parseAndExecute(result, options);
                    }
                    buf = new StringBuffer();
                    continue;
                }
                buf.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        IVFile vfile;
        if (!this.m_sessionEstablished) {
            String jsSourceFilePath = fnOrScript.getSourceName();
            String response = "<init appid=\"APPID\"\r\n      idekey=\"" + this.m_sessionId + "\"\r\n" + "      session=\"" + this.m_sessionId + "\"\r\n" + "      thread=\"" + Thread.currentThread().getId() + "\"\r\n" + "      parent=\"PARENT_APPID\"\r\n" + "      language=\"javascript\"\r\n" + "      protocol_version=\"1.0\"\r\n" + "      fileuri=\"file://" + jsSourceFilePath + "\"\r\n" + "/>";
            this.printResponse(response);
            this.m_sessionEstablished = true;
        }
        String filePath = (vfile = this.m_vFileManager.getFileByName(fnOrScript.getSourceName())) != null ? vfile.toURI().toASCIIString() : fnOrScript.getSourceName();
        return new DBGPDebugFrame(cx, fnOrScript, filePath);
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
        ++s_count;
        String sourceName = fnOrScript.getSourceName();
        if (!this.isValidURL(sourceName) && this.m_vFileManager.getFileByName(sourceName) == null) {
            this.m_vFileManager.createFile(s_count, sourceName, source);
        } else if (this.isValidURL(sourceName) && !this.m_sourceProvider.containsFile(sourceName) && this.m_vFileManager.getFileByName(sourceName) == null) {
            this.m_sourceProvider.addFile(sourceName);
        }
    }

    private boolean isValidURL(String name) {
        try {
            new URL(name);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.m_runTransctionId != null) {
            this.printResponse("<response command=\"run\"\r\nstatus=\"break\" reason=\"ok\" transaction_id=\"" + this.m_runTransctionId + "\">\r\n" + "</response>\r\n");
        }
    }

    public void notifyEnd() {
        this.printResponse("<response command=\"run\"\r\nstatus=\"stopped\" reason=\"ok\" transaction_id=\"" + this.m_runTransctionId + "\">\r\n" + "</response>\r\n");
        this.cleanUpTempFiles();
    }

    private void cleanUpTempFiles() {
        this.m_vFileManager.clear();
    }

    public void access(String property, ScriptableObject object) {
        List<BreakPoint> list = this.m_stackmanager.getManager().getWatchPoints(property);
        for (BreakPoint watchPoint : list) {
            if (watchPoint == null || !watchPoint.m_enabled || !watchPoint.m_isAccess) continue;
            String wkey = String.valueOf(watchPoint.m_file) + watchPoint.m_line;
            String s = this.cache.get(object);
            if (s == null || !s.equals(wkey)) continue;
            this.m_stackmanager.getObserver().update(null, this);
            this.m_stackmanager.waitForNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modification(String property, ScriptableObject object) {
        List<BreakPoint> list = this.m_stackmanager.getManager().getWatchPoints(property);
        if (list != null && this.m_stackmanager.getStackDepth() > 0) {
            for (BreakPoint watchPoint : list) {
                String object2;
                String wkey;
                if (watchPoint == null || !watchPoint.m_enabled) continue;
                String sn = this.m_stackmanager.getStackFrame(0).getSourceName();
                int ln = this.m_stackmanager.getStackFrame(0).getLineNumber();
                String key = String.valueOf(sn) + ln;
                if (key.equals(wkey = String.valueOf(watchPoint.m_file) + watchPoint.m_line)) {
                    this.cache.put(object, wkey);
                }
                if (!watchPoint.m_isModification || (object2 = this.cache.get(object)) == null || !object2.equals(wkey)) continue;
                this.m_stackmanager.getObserver().update(null, this);
                DBGPStackManager dBGPStackManager = this.m_stackmanager;
                synchronized (dBGPStackManager) {
                    try {
                        this.m_stackmanager.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public void setProperty(String name, String value) {
    }

    public void setSuspendOnExit(boolean parseBoolean) {
        this.m_stackmanager.setSuspendOnExit(parseBoolean);
    }

    public void setSuspendOnEntry(boolean parseBoolean) {
        this.m_stackmanager.setSuspendOnEntry(parseBoolean);
    }

    public Context getContext() {
        return this.m_ctx;
    }

    public synchronized Scriptable getCurrentScope() {
        return this.m_scope;
    }

    public synchronized void setCurrentScope(Scriptable scope) {
        this.m_scope = scope;
    }

    static abstract class Command {
        Command() {
        }

        abstract void parseAndExecute(String var1, Map<String, String> var2);
    }
}

