/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.eclipse.vjet.dsf.js.dbgp.ISourceProvider;

public class SourceCommand
extends DBGPDebugger.Command {
    private DBGPDebugger m_debugger;
    private ISourceProvider[] m_providers;

    SourceCommand(DBGPDebugger debugger, ISourceProvider[] providers) {
        this.m_debugger = debugger;
        this.m_providers = providers;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        int beginLine = -1;
        int endLine = -1;
        int success = 1;
        String filePath = options.get("-f");
        String beginLineStr = options.get("-b");
        String endLineStr = options.get("-e");
        if (filePath == null) {
            DBGPDebugFrame frame = this.m_debugger.m_stackmanager.getStackFrame(0);
            filePath = frame.getSourceName();
        }
        if (!this.isNullOrEmpty(beginLineStr)) {
            beginLine = Integer.parseInt(beginLineStr);
        }
        if (!this.isNullOrEmpty(endLineStr)) {
            endLine = Integer.parseInt(endLineStr);
        }
        String contents = this.getSource(filePath, beginLine, endLine);
        contents = Base64Helper.encodeString(contents);
        StringBuilder builder = new StringBuilder();
        builder.append("<response command=\"source\"\r\n          transaction_id=\"").append(options.get("-i")).append("\"\r\n          success=\"").append(success).append("\">\r\n").append(contents).append("\r\n</response>\r\n");
        this.m_debugger.printResponse(builder.toString());
    }

    private String getSource(String filePath, int beginLine, int endLine) {
        String contents = "";
        ISourceProvider[] iSourceProviderArray = this.m_providers;
        int n = this.m_providers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider provider = iSourceProviderArray[n2];
            contents = provider.getSource(filePath, beginLine, endLine);
            if (contents != null && contents.length() > 0) break;
            ++n2;
        }
        return contents;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.equals("");
    }
}

