/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.eclipse.vjet.dsf.js.dbgp.PathUtil;

final class StackGetCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger m_debugger;

    StackGetCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        String string = options.get("-d");
        int level = -1;
        if (string != null) {
            level = Integer.parseInt(string);
        }
        StringBuffer stack = new StringBuffer();
        if (this.m_debugger.m_stackmanager.getStackDepth() >= level) {
            if (level == -1) {
                int a = 0;
                while (a < this.m_debugger.m_stackmanager.getStackDepth()) {
                    this.appendLevel(a, stack);
                    ++a;
                }
            } else {
                this.appendLevel(level, stack);
            }
            this.m_debugger.printResponse("<response command=\"stack_get\"\r\n\r\n          transaction_id=\"" + options.get("-i") + "\">\r\n" + stack + "</response>\r\n");
        }
    }

    private void appendLevel(int level, StringBuffer stack) {
        DBGPDebugFrame stackFrame = this.m_debugger.m_stackmanager.getStackFrame(level);
        String sourceFilePath = stackFrame.getSourceName();
        sourceFilePath = PathUtil.normalize(sourceFilePath);
        stack.append("<stack level=\"" + level + "\"\r\n" + "           type=\"file\"\r\n" + "           filename=\"" + sourceFilePath + "\"\r\n" + "           lineno=\"" + stackFrame.getLineNumber() + "\"\r\n" + "           where=\"" + stackFrame.getWhere() + "\"\r\n" + "           cmdbegin=\"1:0\"\r\n" + "           cmdend=\"" + "1" + ":10\"/>");
    }
}

