/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json.serializer;

import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.serializer.AbstractSerializer;
import org.eclipse.vjet.dsf.json.serializer.ObjectMatch;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SerializerState;

public class EnumSerializer
extends AbstractSerializer {
    private static final Class[] s_serializableClasses = new Class[]{Enum.class};
    private static final Class[] s_JSONClasses = new Class[]{JsonObject.class};

    @Override
    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return clazz.isEnum();
    }

    @Override
    public Class<?>[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public Class<?>[] getSerializableClasses() {
        return s_serializableClasses;
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        JsonObject obj = new JsonObject();
        Enum enum1 = (Enum)o;
        obj.put(enum1.name(), enum1.ordinal());
        return obj;
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class<?> clazz, Object json) throws SerializationException {
        if (this.unmarshall(state, clazz, json) != null) {
            return ObjectMatch.OKAY;
        }
        return ObjectMatch.NULL;
    }

    @Override
    public Object unmarshall(SerializerState state, Class<?> clazz, Object json) throws SerializationException {
        if (json == null) {
            throw new SerializationException("object is null");
        }
        Object object = null;
        JsonObject jsonObject = (JsonObject)json;
        if (jsonObject != null && Enum.class.isAssignableFrom(clazz)) {
            object = Enum.valueOf(clazz, (String)jsonObject.keys().next());
        }
        return object;
    }
}

