/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.coverage;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.common.FileUtils;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.service.serializer.JsonSerializer;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.coverage.JsCoverageBean;
import org.eclipse.vjet.vjo.coverage.JsCoverageFunction;
import org.eclipse.vjet.vjo.coverage.JsCoverageType;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class VjoCoverage
extends BaseScriptable {
    private static final long serialVersionUID = 1L;
    private static final String[] MTD_NAMES = new String[]{"jsCoverage", "jsCoverageReport", "jsFuncLineCount"};
    private static final String VJO_INSTANCE = "alap";
    private static final String COVERAGE_INSTANCE = "cov";
    private HashMap<String, JsCoverageType> types = JsCoverageBean.types;

    public VjoCoverage() {
        this.defineFunctionProperties(MTD_NAMES);
    }

    public void attach(Context cx, Scriptable scope) {
        Object scriptal = Context.javaToJS((Object)((Object)this), (Scriptable)scope);
        String script = "var alap = {};";
        ScriptExecutor.executeScript((String)script, (Scriptable)scope, (Context)cx);
        Scriptable vjo = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)VJO_INSTANCE);
        ScriptableObject.putProperty((Scriptable)vjo, (String)COVERAGE_INSTANCE, (Object)scriptal);
    }

    public void jsCoverage(String type, String method, String lineNum) {
        JsCoverageType covType = this.types.get(type);
        if (covType == null) {
            covType = new JsCoverageType(type);
            covType.addFunction(method);
            this.types.put(type, covType);
        }
        if (covType.getFunction(method) == null) {
            covType.addFunction(method);
        }
        JsCoverageFunction covFunc = covType.getFunction(method);
        covFunc.lineCovered(Integer.parseInt(lineNum));
    }

    public void jsFuncLineCount(String type, String method, String lineNum) {
        JsCoverageType covType = this.types.get(type);
        if (covType == null) {
            covType = new JsCoverageType(type);
            this.types.put(type, covType);
        }
        if (covType.getFunction(method) == null) {
            covType.addFunction(method);
        }
        JsCoverageFunction covFunc = covType.getFunction(method);
        covFunc.setTotalLines(Integer.parseInt(lineNum));
    }

    public Set getTypeNames() {
        return this.types.keySet();
    }

    public void setTypes(HashMap<String, JsCoverageType> coverage) {
        this.types = coverage;
    }

    public int getTypesCount() {
        return this.types.size();
    }

    public int getCoveredTypesCount() {
        int count = 0;
        for (JsCoverageType type : this.types.values()) {
            if (!type.hasCoverage()) continue;
            ++count;
        }
        return count;
    }

    public void jsCoverageReport() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String str = "";
        boolean altTblBackgrd = true;
        String rowGrayBackgrd = "<TR CLASS=\"o\">";
        String rowBackgrd = "<TR>";
        int totalLineCount = 0;
        int coveredLineCount = 0;
        String htmlReportTemplate = FileUtils.readFile((String)JavaSourceLocator.getInstance().getSourceUrl(JsCoverageType.class).getPath().replace("JsCoverageType.java", "JsReportHtmlTemplate.html"), (String)"cp1252");
        int totalFunctionCount = 0;
        int coveredFunctionCount = 0;
        int coveredTypeCount = 0;
        for (JsCoverageType i : this.types.values()) {
            if (altTblBackgrd) {
                altTblBackgrd = false;
                str = String.valueOf(str) + rowGrayBackgrd;
            } else {
                altTblBackgrd = true;
                str = String.valueOf(str) + rowBackgrd;
            }
            coveredLineCount += i.getTypeCoverageLineCount();
            totalLineCount += i.getTypeLineCount();
            totalFunctionCount += i.getNumberOfTotalFunctions();
            coveredFunctionCount += i.getNumberOfCoveredFunctions();
            if (i.hasCoverage()) {
                ++coveredTypeCount;
            }
            String lineCoverage = "0";
            if (i.getTypeLineCount() != 0) {
                lineCoverage = this.formatNumber((double)i.getTypeCoverageLineCount() / (double)i.getTypeLineCount() * 100.0);
            }
            String funcTotalCount = "0";
            if (i.getNumberOfTotalFunctions() != 0) {
                funcTotalCount = this.formatNumber((double)i.getNumberOfCoveredFunctions() / (double)i.getNumberOfTotalFunctions() * 100.0);
            }
            str = String.valueOf(str) + "<TD><a onclick=\"jsCoverage.jsDetailReport('" + i.getTypeName() + "')\">" + i.getTypeName() + "</a></TD><TD>WIP</TD><TD class=\"h\">" + funcTotalCount + "% (" + i.getNumberOfCoveredFunctions() + "/" + i.getNumberOfTotalFunctions() + ")</TD><TD>WIP</TD><TD class=\"h\">" + lineCoverage + "%  (" + i.getTypeCoverageLineCount() + "/" + i.getTypeLineCount() + ")</TD></TR>";
        }
        String html = htmlReportTemplate.replace("ENTER_TYPE_DATA", str);
        html = html.replace("<\\/script>", "</script>");
        String totalCoverage = "0";
        if (totalLineCount != 0) {
            totalCoverage = this.formatNumber((double)coveredLineCount / (double)totalLineCount * 100.0);
        }
        String totalFunc = "0";
        if (totalFunctionCount != 0) {
            totalFunc = this.formatNumber((double)coveredFunctionCount / (double)totalFunctionCount * 100.0);
        }
        String totalTypes = "0";
        if (this.types.size() != 0) {
            totalTypes = this.formatNumber((double)coveredTypeCount / (double)this.types.size() * 100.0);
        }
        String overallCoverage = "<TR><TD>all classes</TD><TD>" + totalTypes + "% (" + coveredTypeCount + "/" + this.types.size() + ")</TD><TD class=\"h\">" + totalFunc + "% (" + coveredFunctionCount + "/" + totalFunctionCount + ")</TD><TD>WIP</TD><TD class=\"h\">" + totalCoverage + "%  (" + coveredLineCount + "/" + totalLineCount + ")</TD></TR>";
        html = html.replace("TOTAL_COVERAGE", overallCoverage);
        JsonSerializer ser = JsonSerializer.getInstance();
        try {
            new JsCoverageBean();
            String json = ser.serialize(this.types);
            Set<String> keys = this.types.keySet();
            for (String key : keys) {
                json = json.replace(key + "\":{", key + "\":{\"javaClass\":\"" + JsCoverageType.class.getName() + "\",");
                HashMap<String, JsCoverageFunction> funcList = this.types.get(key).getTypeFunctionList();
                Set<String> funcKeys = funcList.keySet();
                for (String funcKey : funcKeys) {
                    json = json.replace(funcKey + "\":{", funcKey + "\":{\"javaClass\":\"" + JsCoverageFunction.class.getName() + "\",");
                }
            }
            System.out.println("JSON: " + json);
            String covjs = FileUtils.readFile((String)JavaSourceLocator.getInstance().getSourceUrl(JsCoverageType.class).getPath().replace("JsCoverageType.java", "Coverage.js"), (String)"cp1252");
            html = html.replace("JSSLOT", "var jsCoverage = {};\njsCoverage.htmlReportTemplate = \"" + htmlReportTemplate.replaceAll("\"", "\\\\\"") + "\";\njsCoverage.types =" + json + "\n" + covjs);
            FileUtils.writeFile((String)JavaSourceLocator.getInstance().getSourceUrl(VjoCoverage.class).getPath().replace(".java", ".html"), (String)html, (String)"cp1252");
            FileUtils.writeFile((String)JavaSourceLocator.getInstance().getSourceUrl(VjoCoverage.class).getPath().replace(".java", COVERAGE_INSTANCE + System.currentTimeMillis() + ".txt"), (String)json, (String)"cp1252");
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    public String formatNumber(double val) {
        String num = String.valueOf(val);
        if (num.indexOf(".") > -1) {
            num = num.substring(0, num.indexOf(".") + 2);
        }
        return num;
    }

    public static void main(String[] args) throws UnsupportedEncodingException, SerializationException {
        JsonSerializer ser = JsonSerializer.getInstance();
        try {
            String coverageData = FileUtils.readFile((String)JavaSourceLocator.getInstance().getSourceUrl(VjoCoverage.class).getPath().replace(".java", "cov1231231253577.txt"), (String)"cp1252");
            HashMap obj = (HashMap)ser.deserialize(coverageData, HashMap.class, null);
            String coverageData2 = FileUtils.readFile((String)JavaSourceLocator.getInstance().getSourceUrl(VjoCoverage.class).getPath().replace(".java", "cov1231231311260.txt"), (String)"cp1252");
            HashMap obj2 = (HashMap)ser.deserialize(coverageData2, HashMap.class, null);
            Set keys = obj.keySet();
            for (Object key : keys) {
                HashMap<String, JsCoverageFunction> funcList = ((JsCoverageType)obj.get(key)).getTypeFunctionList();
                HashMap<String, JsCoverageFunction> funcList2 = ((JsCoverageType)obj2.get(key)).getTypeFunctionList();
                Set<String> funcKeys = funcList.keySet();
                for (String funcKey : funcKeys) {
                    JsCoverageFunction func = funcList.get(funcKey);
                    JsCoverageFunction func2 = funcList2.get(funcKey);
                    int[] lineCov = func.getTrackLineCoverage();
                    int[] lineCov2 = func2.getTrackLineCoverage();
                    int i = 0;
                    while (i < lineCov.length) {
                        System.out.println(String.valueOf(lineCov[i]) + " + " + lineCov2[i]);
                        if (lineCov[i] == 0 && lineCov2[i] > 0) {
                            func.setCurLineCovCount(func.getCurLineCovCount() + 1);
                        }
                        lineCov[i] = lineCov[i] + lineCov2[i];
                        ++i;
                    }
                    func.setTrackLineCoverage(lineCov);
                }
            }
            VjoCoverage cov = new VjoCoverage();
            cov.types = obj;
            cov.jsCoverageReport();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

