/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.jsunit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.eclipse.vjet.vjo.jsunit.AssertEqualFailure;
import org.eclipse.vjet.vjo.jsunit.AssertFalseFailure;
import org.eclipse.vjet.vjo.jsunit.AssertTrueFailure;
import org.eclipse.vjet.vjo.jsunit.Failure;
import org.eclipse.vjet.vjo.jsunit.JsUnitFailure;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ScriptRuntime;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.StackInspector;

public class VjoJsUnit
extends BaseScriptable {
    private static final long serialVersionUID = 1L;
    private static final String[] MTD_NAMES = new String[]{"assertEquals", "assertTrue", "assertFalse", "assertNotNull", "fail"};
    private static final String VJO_INSTANCE = "vjo";
    private static final String VJO_JSUNIT_PROP = "jsunit";
    private static final String[] JS_MTDS_PROXIES = new String[]{"function assertTrue (arg0) { return vjo.jsunit.assertTrue(arg0); } ", "function assertFalse (arg0) { return vjo.jsunit.assertFalse(arg0); } ", "function assertEquals (arg0,arg1,arg2) { return vjo.jsunit.assertEquals(arg0,arg1); } ", "function assertNotNull (arg0) { return vjo.jsunit.assertNotNull(arg0); } ", "function fail (arg0) { return vjo.jsunit.fail(arg0); } "};
    private List<JsUnitFailure> m_failures = new ArrayList<JsUnitFailure>();

    public VjoJsUnit() {
        this.defineFunctionProperties(MTD_NAMES);
    }

    public void attach(Context cx, Scriptable scope) {
        Object scriptal = Context.javaToJS((Object)((Object)this), (Scriptable)scope);
        Scriptable vjo = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)VJO_INSTANCE);
        ScriptableObject.putProperty((Scriptable)vjo, (String)VJO_JSUNIT_PROP, (Object)scriptal);
        String[] stringArray = JS_MTDS_PROXIES;
        int n = JS_MTDS_PROXIES.length;
        int n2 = 0;
        while (n2 < n) {
            String script = stringArray[n2];
            ScriptExecutor.executeScript((String)script, (Scriptable)scope, (Context)cx);
            ++n2;
        }
    }

    public void assertEquals(Object expected, Object value) {
        if (expected != null && value != null && expected instanceof Number && value instanceof Number) {
            expected = ScriptRuntime.toString((Object)expected);
            value = ScriptRuntime.toString((Object)value);
        }
        if (!(expected == value || expected != null && expected.equals(value))) {
            this.m_failures.add(new AssertEqualFailure(StackInspector.getStack(), ScriptRuntime.toString((Object)expected), ScriptRuntime.toString((Object)value)));
        }
    }

    public void assertTrue(boolean value) {
        if (!value) {
            this.m_failures.add(new AssertTrueFailure(StackInspector.getStack()));
        }
    }

    public void assertFalse(boolean value) {
        if (value) {
            this.m_failures.add(new AssertFalseFailure(StackInspector.getStack()));
        }
    }

    public void assertNotNull(Object actual) {
        if (actual == null) {
            this.m_failures.add(new AssertTrueFailure(StackInspector.getStack()));
        }
    }

    public void fail(String msg) {
        this.m_failures.add(new Failure(StackInspector.getStack()));
    }

    public List<JsUnitFailure> getFailures() {
        return this.m_failures;
    }

    public String getFailureMsgs() {
        String failMsg = "";
        for (JsUnitFailure failure : this.m_failures) {
            failMsg = String.valueOf(failMsg) + failure.getStackTrace() + failure.NEW_LINE;
        }
        return failMsg;
    }

    public void resetFailures() {
        this.m_failures.clear();
    }
}

