/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.vjet.vjo.loader.VjUrl;

public class VjFetcher {
    private static boolean s_verbose = false;

    public String fetch(VjUrl vjUrl) {
        if (vjUrl == null) {
            throw new RuntimeException("url is null");
        }
        if (s_verbose) {
            System.out.println("Fetching: " + vjUrl.getExternalForm());
        }
        try {
            int n;
            URL url = new URL(vjUrl.getExternalForm());
            InputStreamReader r = new InputStreamReader(new FileInputStream(url.getPath()));
            char[] buffer = new char[512];
            int cursor = 0;
            while ((n = ((Reader)r).read(buffer, cursor, buffer.length - cursor)) >= 0) {
                if ((cursor += n) != buffer.length) continue;
                char[] tmp = new char[buffer.length * 2];
                System.arraycopy(buffer, 0, tmp, 0, cursor);
                buffer = tmp;
            }
            String source = new String(buffer, 0, cursor);
            if (s_verbose) {
                System.out.println("... source = \n" + source);
            }
            return source;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Fail to read from input stream.", e);
        }
    }
}

