/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.loader;

import java.io.PrintStream;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.NativeJavaObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.StackInspector;
import org.mozilla.mod.javascript.Undefined;

public class VjoConsole
extends BaseScriptable {
    private static final long serialVersionUID = 1L;
    private static final String[] MTD_NAMES = new String[]{"print", "println", "printStackTrace"};
    private static final String VJO_INSTANCE = "vjo";
    private static final String VJO_SYSOUT_PROP = "sysout";
    private static final String VJO_SYSERR_PROP = "syserr";
    private final PrintStream m_ps;

    public static void enable(Context cx, Scriptable scope) {
        VjoConsole out = new VjoConsole(false);
        Object scriptOut = Context.javaToJS((Object)((Object)out), (Scriptable)scope);
        Scriptable vjo = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)VJO_INSTANCE);
        ScriptableObject.putProperty((Scriptable)vjo, (String)VJO_SYSOUT_PROP, (Object)scriptOut);
        VjoConsole err = new VjoConsole(true);
        Object scriptErr = Context.javaToJS((Object)((Object)err), (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)vjo, (String)VJO_SYSERR_PROP, (Object)scriptErr);
    }

    public VjoConsole(boolean err) {
        this.m_ps = err ? System.err : System.out;
        this.defineFunctionProperties(MTD_NAMES);
    }

    public void print(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        this.internalPrint(o0, o1, o2, o3, o4, o5, o6, o7, o8, o9);
    }

    public void println(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        this.internalPrint(o0, o1, o2, o3, o4, o5, o6, o7, o8, o9);
        this.m_ps.println();
    }

    public void printStackTrace() {
        for (StackInspector.StackInfo stack : StackInspector.getStack()) {
            this.m_ps.println(stack.toString());
        }
    }

    private void internalPrint(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null && !(o instanceof Undefined)) {
                this.m_ps.print(this.toStringValue(o));
            }
            ++n2;
        }
    }

    private String toStringValue(Object o) {
        if (o instanceof NativeJavaObject) {
            o = ((NativeJavaObject)o).unwrap();
        } else if (o instanceof ScriptableObject) {
            o = ((ScriptableObject)o).getDefaultValue(null);
        }
        return o.toString();
    }
}

