/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.loader;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.loader.VjEvaluator;
import org.eclipse.vjet.vjo.loader.VjFetcher;
import org.eclipse.vjet.vjo.loader.VjResolver;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.NativeFunction;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class VjoLoader
extends BaseScriptable {
    private static final long serialVersionUID = 1L;
    private static final String VJO_INSTANCE = "vjo";
    private static final String VJO_LOADER_PROP = "loader";
    private static final String[] MTD_NAMES = new String[]{"load"};
    private static final String[] PTY_NAMES = new String[]{"async"};
    private static final String ID_VJET = "VJET";
    private static final String ID_COMMON_JS = "CommonJS";
    private static final String PTY_REQUIRE = "require";
    private static final String PTY_GET_MODULE_MGR = "getModuleMgr";
    private static final String PTY_RESOLVER = "resolver";
    private static final String PTY_FETCHER = "fetcher";
    private static final String PTY_EVALUATOR = "evaluator";
    final Context m_cx;
    final Scriptable m_scope;
    private static boolean s_verbose = false;
    private final boolean m_async = false;

    public static void enable(Context cx, Scriptable scope) {
        Object require = ScriptableObject.getProperty((Scriptable)scope, (String)PTY_REQUIRE);
        if (require != Scriptable.NOT_FOUND) {
            Scriptable requireObj = (Scriptable)require;
            VjResolver resolver = new VjResolver();
            VjFetcher fetcher = new VjFetcher();
            VjEvaluator evaluator = new VjEvaluator(cx);
            NativeFunction mgrGetter = (NativeFunction)ScriptableObject.getProperty((Scriptable)requireObj, (String)PTY_GET_MODULE_MGR);
            Object[] vjetArgs = new Object[]{ID_VJET};
            ScriptableObject vjetMgr = (ScriptableObject)mgrGetter.call(cx, scope, requireObj, vjetArgs);
            ScriptableObject.putProperty((Scriptable)vjetMgr, (String)PTY_RESOLVER, (Object)resolver);
            ScriptableObject.putProperty((Scriptable)vjetMgr, (String)PTY_FETCHER, (Object)fetcher);
            ScriptableObject.putProperty((Scriptable)vjetMgr, (String)PTY_EVALUATOR, (Object)evaluator);
            Object[] commonJsArgs = new Object[]{ID_COMMON_JS};
            ScriptableObject commonJsMgr = (ScriptableObject)mgrGetter.call(cx, scope, requireObj, commonJsArgs);
            ScriptableObject.putProperty((Scriptable)commonJsMgr, (String)PTY_RESOLVER, (Object)resolver);
            ScriptableObject.putProperty((Scriptable)commonJsMgr, (String)PTY_FETCHER, (Object)fetcher);
            ScriptableObject.putProperty((Scriptable)commonJsMgr, (String)PTY_EVALUATOR, (Object)evaluator);
        } else {
            Scriptable vjo = (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)VJO_INSTANCE);
            if (vjo != null) {
                VjoLoader loader = new VjoLoader(cx, scope);
                Object scriptObj = Context.javaToJS((Object)((Object)loader), (Scriptable)scope);
                ScriptableObject.putProperty((Scriptable)vjo, (String)VJO_LOADER_PROP, (Object)scriptObj);
            }
        }
    }

    public VjoLoader(Context cx, Scriptable scope) {
        this.m_cx = cx;
        this.m_scope = scope;
        this.defineFunctionProperties(MTD_NAMES);
        this.defineProperties(PTY_NAMES);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(String uri) {
        if (s_verbose) {
            System.out.println("loading: " + uri);
        }
        URL sourceUrl = null;
        String clzName = null;
        do {
            try {
                sourceUrl = JavaSourceLocator.getInstance().getSourceUrl(uri, ".js");
                clzName = uri;
            }
            catch (Throwable throwable) {}
            if (sourceUrl != null) continue;
            String path = String.valueOf(uri.replace(".", "/")) + ".js";
            int index = path.lastIndexOf("/");
            String resourceName = path;
            String relDir = "";
            if (index > 0) {
                relDir = path.substring(0, index);
                resourceName = path.substring(index + 1);
            }
            try {
                sourceUrl = ResourceUtil.getResource((String)relDir, (String)resourceName);
                clzName = uri;
            }
            catch (IOException iOException) {}
        } while ((uri = VjoLoader.getContainer(uri)) != null && sourceUrl == null);
        if (sourceUrl != null) {
            try {
                this.m_cx.evaluateReader(this.m_scope, (Reader)new InputStreamReader(sourceUrl.openStream()), sourceUrl.toExternalForm(), 1, null);
                if (!DapCtx.ctx().isActiveMode() || !VjoLoader.isJ2JType(clzName)) return;
                this.m_cx.evaluateString(this.m_scope, String.valueOf(clzName) + "=Packages." + clzName + ";", clzName, 1, null);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            if (this.isVjoType(clzName)) return;
            throw new DsfRuntimeException("could not find " + clzName);
        }
    }

    private boolean isVjoType(String clzName) {
        if (clzName.endsWith("Class")) {
            return true;
        }
        return clzName.endsWith("Object");
    }

    public boolean getAsync() {
        return false;
    }

    private static String getContainer(String uri) {
        String[] parts = uri.split("\\.");
        int len = parts.length;
        if (len <= 1 || parts[len - 2].toLowerCase().equals(parts[len - 2])) {
            return null;
        }
        String clz = parts[0];
        int i = 1;
        while (i < len - 1) {
            clz = String.valueOf(clz) + "." + parts[i];
            ++i;
        }
        return clz;
    }

    private static boolean isJ2JType(String uri) {
        try {
            Class<?> clz = Class.forName(uri, false, VjoLoader.class.getClassLoader());
            return !IJsJavaProxy.class.isAssignableFrom(clz);
        }
        catch (Exception e) {
            if (s_verbose) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean isVerbose() {
        return s_verbose;
    }

    public static void setVerbose(boolean verbose) {
        s_verbose = verbose;
    }
}

