/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.Map;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.ReplaySpeed;
import org.eclipse.vjet.vsf.dapunit.DefaultErrorReporter;
import org.eclipse.vjet.vsf.dapunit.IDapUnitErrorReporter;
import org.eclipse.vjet.vsf.dapunit.IDomValidator;
import org.eclipse.vjet.vsf.dapunit.IMsgValidator;
import org.eclipse.vjet.vsf.dapunit.SimpleDomValidator;
import org.eclipse.vjet.vsf.dapunit.SimpleMsgValidator;

public class DapUnitConfig {
    private IMsgValidator m_defaultMsgValidator;
    private IDomValidator m_defaultDomValidator;
    private Map<Class<? extends DapCaptureData.IDomChange>, IDomValidator> m_validators;
    private IDapUnitErrorReporter m_errorReporter;
    private boolean m_enableMockHttpClient;
    private ReplaySpeed m_replaySpeed = ReplaySpeed.FAST;

    public final IMsgValidator getDefaultMsgValidator() {
        if (this.m_defaultMsgValidator == null) {
            this.m_defaultMsgValidator = new SimpleMsgValidator();
        }
        return this.m_defaultMsgValidator;
    }

    public DapUnitConfig setDefaultMsgValidator(IMsgValidator msgValidator) {
        this.m_defaultMsgValidator = msgValidator;
        return this;
    }

    public final IDomValidator getDefaultDomValidator() {
        if (this.m_defaultDomValidator == null) {
            this.m_defaultDomValidator = new SimpleDomValidator();
        }
        return this.m_defaultDomValidator;
    }

    public DapUnitConfig setDefaultDomValidator(IDomValidator domValidator) {
        this.m_defaultDomValidator = domValidator;
        return this;
    }

    public DapUnitConfig setDomValidators(Map<Class<? extends DapCaptureData.IDomChange>, IDomValidator> validators) {
        this.m_validators = validators;
        return this;
    }

    public IDomValidator getValidator(Class<? extends DapCaptureData.IDomChange> domChangeType) {
        if (this.m_defaultDomValidator == null) {
            this.m_defaultDomValidator = new SimpleDomValidator();
        }
        if (domChangeType == null) {
            return this.m_defaultDomValidator;
        }
        IDomValidator validator = null;
        if (this.m_validators != null) {
            validator = this.m_validators.get(domChangeType);
        }
        return validator == null ? this.m_defaultDomValidator : validator;
    }

    public final IDapUnitErrorReporter getErrorReporter() {
        if (this.m_errorReporter == null) {
            this.m_errorReporter = new DefaultErrorReporter();
        }
        return this.m_errorReporter;
    }

    public void setErrorReporter(IDapUnitErrorReporter errorReporter) {
        this.m_errorReporter = errorReporter;
    }

    public boolean isEnableMockHttpClient() {
        return this.m_enableMockHttpClient;
    }

    public void setEnableMockHttpClient(boolean enableMockHttpClient) {
        this.m_enableMockHttpClient = enableMockHttpClient;
    }

    public void setReplaySpeed(ReplaySpeed speed) {
        this.m_replaySpeed = speed;
    }

    public ReplaySpeed getReplaySpeed() {
        return this.m_replaySpeed;
    }
}

