/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.cnr.DapCapture;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureXmlSerializer;
import org.eclipse.vjet.dsf.dap.cnr.IDapCaptureListener;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.HtmlWriterHelper;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.liveconnect.client.DLCClientHelper;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.simple.SimpleDLCClient;
import org.eclipse.vjet.dsf.spec.view.DefaultViewSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.dsf.util.NodeToDHtmlDocument;
import org.eclipse.vjet.vsf.aggregator.js.JsProcessor;
import org.eclipse.vjet.vsf.dapunit.AssertionExecutor;
import org.eclipse.vjet.vsf.dapunit.AwuClientProxy;
import org.eclipse.vjet.vsf.dapunit.DapUnitConfig;
import org.eclipse.vjet.vsf.dapunit.DapUnitInstantValidator;
import org.eclipse.vjet.vsf.dapunit.DapUnitPlayer;
import org.eclipse.vjet.vsf.dapunit.MockDapHttpClient;
import org.eclipse.vjet.vsf.dapunit.MockDlcDispatcher;
import org.eclipse.vjet.vsf.dapunit.UserAgentsEnum;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DapUnitDriver {
    private final List<View> m_views = new ArrayList<View>(1);
    private final DapCaptureData m_captureData;
    private DapUnitPlayer m_player;
    private DapUnitInstantValidator m_validator;
    private AssertionExecutor m_executor;
    private DapUnitConfig m_config;
    private UserAgentsEnum[] m_userAgents;

    public DapUnitDriver(URL capturedXmlFilePath) {
        this.m_captureData = this.deserializeXml(capturedXmlFilePath);
    }

    public DapUnitDriver(String capturedXmlFilePath) {
        this.m_captureData = null;
    }

    public final DapUnitConfig getConfig() {
        if (this.m_config == null) {
            this.m_config = new DapUnitConfig();
        }
        return this.m_config;
    }

    public void setConfig(DapUnitConfig config) {
        this.m_config = config;
    }

    public void addView(String html) {
        this.m_views.add(new View(html, 0L));
    }

    public DapUnitDriver addView(DNode node) {
        this.assertNotNull(node);
        this.m_views.add(new View(this.getDapHtml(this.processDoc(node, null)), 0L));
        return this;
    }

    public DapUnitDriver addView(DNode node, long timeout) {
        this.assertNotNull(node);
        this.m_views.add(new View(this.getDapHtml(this.processDoc(node, null)), timeout));
        return this;
    }

    public DapUnitDriver addView(DNode node, IViewSpec viewSpec) {
        this.assertNotNull(node);
        this.m_views.add(new View(this.getDapHtml(this.processDoc(node, viewSpec)), 0L));
        return this;
    }

    public DapUnitDriver addView(DNode node, IViewSpec viewSpec, long timeout) {
        this.assertNotNull(node);
        this.m_views.add(new View(this.getDapHtml(this.processDoc(node, viewSpec)), timeout));
        return this;
    }

    public DapUnitDriver setUserAgents(UserAgentsEnum[] userAgents) {
        this.m_userAgents = userAgents;
        return this;
    }

    public DapUnitInstantValidator getValidator() {
        return this.m_validator;
    }

    public DapUnitDriver run(DapUnitConfig config) {
        this.m_config = config;
        this.test(new MockDlcDispatcher(this.m_config));
        if (this.m_userAgents != null && this.m_userAgents.length > 0) {
            String captureUserAgent = this.m_captureData.getUserAgent();
            UserAgentsEnum[] userAgentsEnumArray = this.m_userAgents;
            int n = this.m_userAgents.length;
            int n2 = 0;
            while (n2 < n) {
                UserAgentsEnum userAgent = userAgentsEnumArray[n2];
                if (userAgent != null && !userAgent.getName().equals(captureUserAgent)) {
                    this.test(new MockDlcDispatcher(this.m_config, userAgent));
                }
                ++n2;
            }
        }
        return this;
    }

    public DapUnitDriver run(UserAgentsEnum userAgent, DapUnitConfig config) {
        this.m_config = config;
        this.test(new MockDlcDispatcher(this.m_config, userAgent));
        return this;
    }

    private void test(MockDlcDispatcher dlcDispatcher) {
        AwuClientProxy.setDispatcher(dlcDispatcher);
        try {
            Assert.assertEquals((int)this.m_captureData.getViewCaptures().size(), (int)this.m_views.size());
            DapCapture dapCapture = new DapCapture();
            dapCapture.getCapturedData().setUserAgent(this.m_captureData.getUserAgent());
            this.m_player = new DapUnitPlayer(this.m_captureData.getInitEventCapture());
            this.m_validator = new DapUnitInstantValidator(this.getConfig()).setActualCaptureData(dapCapture.getCapturedData());
            this.m_executor = new AssertionExecutor(this.getConfig());
            DapConfig config = DapCtx.ctx().getDapConfig();
            config.addCaptureListener((IDapCaptureListener)this.m_validator);
            if (this.m_config.isEnableMockHttpClient()) {
                MockDapHttpClient mockClient = new MockDapHttpClient(this.m_captureData.getHttpCallCaptures().values(), 1);
                config.setHttpClient((IDapHttpClient)mockClient);
            }
            Iterator<View> viewItr = this.m_views.iterator();
            for (DapCaptureData.ViewCapture viewCapture : this.m_captureData.getViewCaptures()) {
                View view = viewItr.next();
                this.m_validator.startView(viewCapture);
                dlcDispatcher.startView(viewCapture);
                this.m_player.play(view.m_html, dapCapture, this.m_captureData.getInitEventCapture(), viewCapture, view.m_timeout, dlcDispatcher, this.m_validator, this.m_executor);
            }
        }
        finally {
            AwuClientProxy.setDispatcher(null);
            DapCtx.ctx().setDapConfig(null);
            DapCtx.ctx().setWindow(null);
        }
    }

    private DHtmlDocument processDoc(DNode node, IViewSpec viewSpec) {
        DHtmlDocument document;
        if (node instanceof DHtmlDocument) {
            document = (DHtmlDocument)node;
        } else {
            document = NodeToDHtmlDocument.createHtmlDocumentContaining((Node)node, (boolean)false);
            if (viewSpec == null) {
                viewSpec = new DefaultViewSpec();
            }
            new JsProcessor().process((DDocument)document, viewSpec);
        }
        return document;
    }

    private DapCaptureData deserializeXml(URL filePath) {
        DapCaptureData data = null;
        try {
            data = new DapCaptureXmlSerializer((IIndenter)new IIndenter.Pretty()).deserialize(filePath.openStream());
        }
        catch (IOException iOException) {
            throw new DsfRuntimeException("Captured data is not found: " + filePath);
        }
        if (data == null) {
            throw new DsfRuntimeException("Failed to deserialize " + filePath);
        }
        return data;
    }

    private String getDapHtml(DHtmlDocument doc) {
        this.removeComments((Node)doc);
        DLCClientHelper.enableDLC((String)"localhost", (int)1024, (DHtmlDocument)doc, (IDLCClient)SimpleDLCClient.getInstance());
        return HtmlWriterHelper.asString((Node)doc);
    }

    private void removeComments(Node node) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof DComment) {
                node.removeChild(child);
            } else {
                this.removeComments(child);
            }
            --i;
        }
    }

    private void assertNotNull(DNode node) {
        if (node == null) {
            throw new DsfRuntimeException("node is null");
        }
    }

    private static class View {
        private String m_html;
        private long m_timeout;

        private View(String html, long timeout) {
            this.m_html = html;
            this.m_timeout = timeout;
        }
    }
}

