/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.IDapCaptureListener;
import org.eclipse.vjet.vsf.dapunit.DapUnitConfig;
import org.eclipse.vjet.vsf.dapunit.DomError;

public class DapUnitInstantValidator
implements IDapCaptureListener {
    private DapCaptureData.ViewCapture m_curViewCapture;
    private DapCaptureData.IEventCapture m_curEventCapture;
    private Iterator<DapCaptureData.IActionInfo> m_expectedActionItr;
    private DapCaptureData m_actualCaptureData;
    private DapUnitConfig m_config;
    private static final String ASSERT_NULL = "ActualEventCapture is null for event";
    private static final String ASSERT_EQUALS = "ActualEventCapture is different for event";
    private static final String CONS_NULL = " NULL";

    public DapUnitInstantValidator(DapUnitConfig config) {
        if (config == null) {
            this.m_config = new DapUnitConfig();
        }
        this.m_config = config;
    }

    public void onDomCapture(DapCaptureData.IDomChange domChange) {
        DapCaptureData.IDomChange expected = this.getExpectedDomChange();
        DomError domError = this.m_config.getValidator(domChange.getClass()).validate(expected, domChange);
        if (domError != null) {
            this.m_config.getErrorReporter().addDomError(domError, expected, domChange, this.m_curEventCapture, this.m_curViewCapture);
        }
    }

    public DapUnitInstantValidator setActualCaptureData(DapCaptureData actualCaptureData) {
        this.m_actualCaptureData = actualCaptureData;
        return this;
    }

    public DapUnitInstantValidator startInit(DapCaptureData.EventCapture expectedInitCapture) {
        if (this.m_actualCaptureData == null) {
            throw new DsfRuntimeException("m_actualCaptureData is null");
        }
        this.startEvent((DapCaptureData.IEventCapture)expectedInitCapture);
        return this;
    }

    public DapUnitInstantValidator endInit() {
        DapCaptureData.EventCapture actualEventCapture = this.m_actualCaptureData.getInitEventCapture();
        if (actualEventCapture instanceof DapCaptureData.EventCapture) {
            DapCaptureData.EventCapture ec = actualEventCapture;
            Assert.assertNotNull((String)ASSERT_NULL.concat(ec.getEvent() != null ? ec.getEvent().getPayload() : CONS_NULL), (Object)actualEventCapture);
            Assert.assertEquals((String)ASSERT_EQUALS.concat(ec.getEvent() != null ? ec.getEvent().getPayload() : CONS_NULL), (int)this.m_curEventCapture.getDomChangeSize(), (int)ec.getDomChangeSize());
        }
        this.m_curEventCapture = null;
        this.m_expectedActionItr = null;
        return this;
    }

    public DapUnitInstantValidator startView(DapCaptureData.ViewCapture expectedViewCapture) {
        if (expectedViewCapture == null) {
            throw new DsfRuntimeException("expectedViewCapture is null");
        }
        this.m_curViewCapture = expectedViewCapture;
        return this;
    }

    public DapUnitInstantValidator startEvent(DapCaptureData.IEventCapture expectedEventCapture) {
        if (expectedEventCapture == null) {
            throw new DsfRuntimeException("expectedEventCapture is null");
        }
        this.m_curEventCapture = expectedEventCapture;
        this.m_expectedActionItr = this.m_curEventCapture.getActionsIter();
        return this;
    }

    public DapUnitInstantValidator endEvent() {
        DapCaptureData.IEventCapture actualEventCapture = this.m_actualCaptureData.getCurrentEventCapture();
        if (actualEventCapture instanceof DapCaptureData.EventCapture) {
            DapCaptureData.EventCapture ec = (DapCaptureData.EventCapture)actualEventCapture;
            Assert.assertNotNull((String)ASSERT_NULL.concat(ec.getEvent() != null ? ec.getEvent().getPayload() : CONS_NULL), (Object)actualEventCapture);
            Assert.assertEquals((String)ASSERT_EQUALS.concat(ec.getEvent() != null ? ec.getEvent().getPayload() : CONS_NULL), (int)this.m_curEventCapture.getDomChangeSize(), (int)ec.getDomChangeSize());
            this.m_curEventCapture = null;
            this.m_expectedActionItr = null;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private DapCaptureData.IDomChange getExpectedDomChange() {
        if (this.m_curViewCapture == null) {
            throw new DsfRuntimeException("m_curViewCapture is null");
        }
        if (this.m_curEventCapture == null) {
            throw new DsfRuntimeException("m_curEventCapture is null");
        }
        if (this.m_expectedActionItr != null) ** GOTO lbl10
        throw new DsfRuntimeException("m_actionItr is null");
lbl-1000:
        // 1 sources

        {
            actionInfo = this.m_expectedActionItr.next();
            if (!(actionInfo instanceof DapCaptureData.IDomChange)) continue;
            return (DapCaptureData.IDomChange)actionInfo;
lbl10:
            // 2 sources

            ** while (this.m_expectedActionItr.hasNext())
        }
lbl11:
        // 1 sources

        return null;
    }
}

