/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.vsf.dapunit.DapUnitValidationFailureException;
import org.eclipse.vjet.vsf.dapunit.DomError;
import org.eclipse.vjet.vsf.dapunit.IDapUnitError;
import org.eclipse.vjet.vsf.dapunit.IDapUnitErrorReporter;
import org.eclipse.vjet.vsf.dapunit.MsgError;

public class DefaultErrorReporter
implements IDapUnitErrorReporter {
    private boolean m_traceError = true;
    private String m_testName;
    private List<IDapUnitError> m_errors = new ArrayList<IDapUnitError>();

    @Override
    public void setTestName(String testName) {
        this.m_testName = testName;
    }

    @Override
    public void enableTraceError() {
        this.m_traceError = true;
    }

    @Override
    public void disableTraceError() {
        this.m_traceError = false;
    }

    @Override
    public void addDomError(DomError error, DapCaptureData.IDomChange expectedDomChange, DapCaptureData.IDomChange actualDomChange, DapCaptureData.IEventCapture eventCapture, DapCaptureData.ViewCapture view) {
        if (this.m_errors.isEmpty()) {
            System.err.println("DapUnit test failured - " + this.m_testName + ":");
        }
        System.err.println(String.valueOf(String.valueOf(this.m_errors.size() + 1)) + ") " + error.getMsg() + ":");
        StringBuffer sb = new StringBuffer();
        if (eventCapture != null) {
            sb.append(eventCapture.getInfo());
        }
        sb.append("\n\t").append("Expected:").append(expectedDomChange == null ? "null" : expectedDomChange.toString());
        sb.append("\n\t").append("  Actual:").append(actualDomChange == null ? "null" : actualDomChange.toString());
        try {
            try {
                if (this.m_traceError) {
                    throw new DapUnitValidationFailureException(sb.toString());
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stream));
                System.err.println(stream.toString());
                this.m_errors.add(error);
            }
        }
        finally {
            this.m_errors.add(error);
        }
    }

    @Override
    public void addMsgError(MsgError error, String expectedDlcMsg, String actualDlcMsg, DapCaptureData.IEventCapture eventCapture, DapCaptureData.ViewCapture view) {
        if (this.m_errors.isEmpty()) {
            System.err.println("DapUnit test failured - " + this.m_testName + ":");
        }
        System.err.println(String.valueOf(String.valueOf(this.m_errors.size() + 1)) + ") " + error.getMsg() + ":");
        StringBuffer sb = new StringBuffer();
        if (eventCapture != null) {
            sb.append(eventCapture.getInfo());
        }
        sb.append("\n\t").append("Expected:").append(expectedDlcMsg == null ? "null" : expectedDlcMsg.toString());
        sb.append("\n\t").append("  Actual:").append(actualDlcMsg == null ? "null" : actualDlcMsg.toString());
        try {
            try {
                if (this.m_traceError) {
                    throw new DapUnitValidationFailureException(sb.toString());
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stream));
                System.err.println(stream.toString());
                this.m_errors.add(error);
            }
        }
        finally {
            this.m_errors.add(error);
        }
    }

    @Override
    public List<IDapUnitError> getDomErrors() {
        return this.m_errors;
    }

    @Override
    public void addAssertionFailure(IDapUnitError error, String expected, String actual, String input) {
        System.err.println(String.valueOf(String.valueOf(this.m_errors.size() + 1)) + ") DapUnit validation failure: ");
        StringBuffer sb = new StringBuffer();
        if (input != null) {
            sb.append("input - ").append(input);
        }
        sb.append("\n\t").append("Expected:").append(expected == null ? "null" : expected);
        sb.append("\n\t").append("  Actual:").append(actual == null ? "null" : actual);
        try {
            try {
                if (this.m_traceError) {
                    throw new DapUnitValidationFailureException(sb.toString());
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stream));
                System.err.println(stream.toString());
                this.m_errors.add(error);
            }
        }
        finally {
            this.m_errors.add(error);
        }
    }
}

