/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureXmlSerializer;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.vsf.dervlet.DsfDervlet;

public class DapUnitConsoleHandler
implements IDapConsoleHandler {
    public static final String GEN_DAP_UNIT = "GEN_DAP_UNIT";
    private static final int CMD_LEN = "GEN_DAP_UNIT".length();
    private static final String[] INPUTS = new String[]{"GEN_DAP_UNIT"};
    private Class<?> m_baseDapUnitType;
    private String m_targetRoot;
    private String m_targetName;
    private String m_xmlPath;
    private String m_dapUnitPath;
    private String m_dervletName;
    private String m_dapUnitName;
    private static final String TEMPLATE_NAME = "DapUnitTemplate.txt";
    private URL m_templateURL;
    private boolean m_forIE;
    private boolean m_forFF;
    private List<ITemplateHandler> m_handlers = new ArrayList<ITemplateHandler>();
    private static final IIndenter PRETTY = new IIndenter.Pretty();

    public DapUnitConsoleHandler() {
        try {
            this.m_templateURL = ResourceUtil.getResource(this.getClass(), (String)TEMPLATE_NAME);
        }
        catch (Exception exception) {
            throw new DsfRuntimeException("Cannot find DapUnitTemplate.txt");
        }
    }

    public boolean isForIE() {
        return this.m_forIE;
    }

    public void setForIE(boolean m_forie) {
        this.m_forIE = m_forie;
    }

    public boolean isForFF() {
        return this.m_forFF;
    }

    public void setForFF(boolean m_forff) {
        this.m_forFF = m_forff;
    }

    public String[] getSupportedInputs() {
        return INPUTS;
    }

    public void handle(String input) {
        String cmd = input.toUpperCase();
        if (cmd.startsWith(GEN_DAP_UNIT)) {
            String saveName;
            if (input.length() > CMD_LEN && (saveName = input.substring(CMD_LEN).trim()).length() > 0) {
                char first = saveName.charAt(0);
                if (Character.isLowerCase(first)) {
                    saveName = saveName.replaceFirst(String.valueOf(first), String.valueOf(Character.toUpperCase(first)));
                }
                this.m_dapUnitName = saveName;
            }
            this.genDapUnit(this.getCaptureData());
        }
    }

    public String getXmlPath() {
        return this.m_xmlPath;
    }

    public String getDapUnitPath() {
        return this.m_dapUnitPath;
    }

    public String getTargetRoot() {
        return this.m_targetRoot;
    }

    public void setTargetRoot(String targetRoot) {
        this.m_targetRoot = targetRoot;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    public void setTargetName(String targetName) {
        this.m_targetName = targetName;
    }

    public void genDapUnit(DapCaptureData captureData) {
        if (captureData == null) {
            System.err.println("capture is not enabled");
            return;
        }
        this.parseFilePath();
        File file = new File(this.m_xmlPath);
        try {
            FileOutputStream out = new FileOutputStream(file);
            new DapCaptureXmlSerializer(PRETTY).serialize(captureData, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ArrayList<ITemplateHandler> handlers = new ArrayList<ITemplateHandler>();
            PkgNameHandler pkgHandler = new PkgNameHandler(this.m_targetName.substring(0, this.m_targetName.lastIndexOf(".")));
            ClzNameHandler clzNameHandler = new ClzNameHandler(this.m_dapUnitName);
            NodeToTestHandler nodeToTestHandler = new NodeToTestHandler(this.m_targetName);
            handlers.add(pkgHandler);
            handlers.add(clzNameHandler);
            handlers.add(nodeToTestHandler);
            handlers.addAll(this.m_handlers);
            handlers.add(CleanupHandler.INSTANCE);
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_dapUnitPath, false));
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_templateURL.openStream()));
            String tempLine = null;
            while ((tempLine = reader.readLine()) != null) {
                for (ITemplateHandler handler : handlers) {
                    if (!handler.accept(tempLine)) continue;
                    tempLine = handler.handle(tempLine);
                }
                if (tempLine.length() <= 0) continue;
                writer.write(tempLine);
                writer.newLine();
            }
            reader.close();
            writer.close();
            System.out.println("\n\n--- DapUnit test file based on Dervlet [ " + this.m_dervletName + " ] is generated --- ");
            System.out.println("Location: " + this.m_dapUnitPath + "\n");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public void addTemplateHandler(ITemplateHandler handler) {
        this.m_handlers.add(handler);
    }

    public void removeTemplateHandler(ITemplateHandler handler) {
        this.m_handlers.remove(handler);
    }

    public void setUserAgents(String[] uas) {
        this.addTemplateHandler(new UserAgentHandler(uas));
    }

    public void setRegexFilters(String[] filters) {
        this.addTemplateHandler(new RegexFilterHandler(filters));
    }

    private DapCaptureData getCaptureData() {
        return DapCtx.ctx().getSession().getCaptureReplay().getCapturedData();
    }

    private void parseFilePath() {
        String path = this.m_targetName == null ? "" : this.m_targetName.replace(".", File.separator);
        path = path.substring(0, path.lastIndexOf(File.separator) + 1);
        this.m_dervletName = this.m_targetName.substring(this.m_targetName.lastIndexOf(".") + 1, this.m_targetName.length());
        if (this.m_dapUnitName == null) {
            this.m_dapUnitName = this.m_dervletName;
            if (this.m_forFF) {
                this.m_dapUnitName = String.valueOf(this.m_dapUnitName) + "_FF_";
            }
            if (this.m_forIE) {
                this.m_dapUnitName = String.valueOf(this.m_dapUnitName) + "_IE_";
            }
        }
        this.m_xmlPath = String.valueOf(this.m_targetRoot) + path + this.m_dapUnitName + "DapCapture.xml";
        this.m_dapUnitPath = String.valueOf(this.m_targetRoot) + path + this.m_dapUnitName + "DapUnit.java";
    }

    private static boolean isExtendedFromDNode(Class<?> c) {
        return DNode.class.isAssignableFrom(c);
    }

    private static class CleanupHandler
    implements ITemplateHandler {
        private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\[\\w+\\]");
        private static final CleanupHandler INSTANCE = new CleanupHandler();
        private Matcher m_mathcer;

        @Override
        public boolean accept(String tempLine) {
            this.m_mathcer = PLACE_HOLDER_PATTERN.matcher(tempLine);
            return this.m_mathcer.find();
        }

        @Override
        public String handle(String tempLine) {
            do {
                tempLine = tempLine.replace(this.m_mathcer.group(), "");
            } while (this.m_mathcer.find());
            return tempLine;
        }
    }

    private static class ClzNameHandler
    implements ITemplateHandler {
        private String m_clzName;

        public ClzNameHandler(String clzName) {
            this.m_clzName = clzName;
        }

        @Override
        public String handle(String tempLine) {
            return tempLine.replace("[TestClzName]", this.m_clzName);
        }

        @Override
        public boolean accept(String tempLine) {
            return tempLine.contains("[TestClzName]");
        }
    }

    public static interface ITemplateHandler {
        public boolean accept(String var1);

        public String handle(String var1);
    }

    private static class NodeToTestHandler
    implements ITemplateHandler {
        List<String> m_testCandidates = new ArrayList<String>();

        public boolean nodeToTestHandlerForVisualTest(Class<?> clz, String shtClzNm) {
            try {
                Class<?> BASE_CLZ = Class.forName("com.ebay.darwin.out.visualtest.DarwinVisualTest");
                if (BASE_CLZ.isAssignableFrom(clz)) {
                    this.m_testCandidates.add("new " + shtClzNm + "()." + "createDecoratedDoc()");
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return false;
        }

        public NodeToTestHandler(String fullClzName) {
            String methodName = "";
            String shortClzName = fullClzName.substring(fullClzName.lastIndexOf(".") + 1, fullClzName.length());
            try {
                Class<?> clz = Class.forName(fullClzName);
                if (!this.nodeToTestHandlerForVisualTest(clz, shortClzName)) {
                    Method[] methods;
                    Method[] methodArray = methods = clz.getDeclaredMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m = methodArray[n2];
                        if (DapUnitConsoleHandler.isExtendedFromDNode(m.getReturnType()) && Modifier.isPublic(m.getModifiers())) {
                            methodName = m.toGenericString();
                            if (Modifier.isStatic(m.getModifiers())) {
                                methodName = methodName.substring(methodName.lastIndexOf(".") + 1);
                                this.m_testCandidates.add(String.valueOf(shortClzName) + "." + methodName);
                            } else {
                                methodName = methodName.substring(methodName.lastIndexOf(".") + 1);
                                this.m_testCandidates.add("new " + shortClzName + "()." + methodName);
                            }
                        }
                        ++n2;
                    }
                }
                if (this.m_testCandidates.size() == 0 && DsfDervlet.class.isAssignableFrom(clz)) {
                    this.m_testCandidates.add("new " + shortClzName + "().createFragment()");
                }
            }
            catch (ClassNotFoundException cne) {
                cne.printStackTrace();
            }
        }

        @Override
        public String handle(String tempLine) {
            if (this.m_testCandidates.size() > 0) {
                tempLine = tempLine.replace("[NodeToTest]", this.m_testCandidates.get(0));
                if (this.m_testCandidates.size() > 1) {
                    System.err.print("\n\n\n");
                    System.err.println("--- Found multiple test candidates in your Dervlet ---");
                    for (String s : this.m_testCandidates) {
                        System.err.println(s);
                    }
                    System.err.println("Will use [" + this.m_testCandidates.get(0) + "] as test node. \n");
                }
            }
            return tempLine;
        }

        @Override
        public boolean accept(String tempLine) {
            return tempLine.contains("[NodeToTest]");
        }
    }

    private static class PkgNameHandler
    implements ITemplateHandler {
        private String m_pkgName;

        public PkgNameHandler(String pkgName) {
            this.m_pkgName = pkgName;
        }

        @Override
        public String handle(String tempLine) {
            return tempLine.replace("[PackageName]", this.m_pkgName);
        }

        @Override
        public boolean accept(String tempLine) {
            return tempLine.contains("[PackageName]");
        }
    }

    public static class RegexFilterHandler
    implements ITemplateHandler {
        private static final String IMPORT = "import com.ebay.dsf.test.fwk.dapunit.SimpleDomValidator;";
        private String[] m_filters;
        private boolean m_bImport;
        private boolean m_bMethod;

        public RegexFilterHandler(String[] filters) {
            this.m_filters = filters;
        }

        @Override
        public boolean accept(String tempLine) {
            if (this.m_filters == null || this.m_filters.length == 0) {
                return false;
            }
            this.m_bImport = tempLine.contains("[FilterImport]");
            this.m_bMethod = tempLine.contains("[Filter]");
            return this.m_bImport || this.m_bMethod;
        }

        @Override
        public String handle(String tempLine) {
            if (this.m_bImport) {
                tempLine = tempLine.replace("[FilterImport]", IMPORT);
            } else if (this.m_bMethod) {
                StringBuilder sb = new StringBuilder();
                sb.append("getConfig().setDefaultDomValidator(new SimpleDomValidator(new String[]{ ");
                int i = 0;
                int len = this.m_filters.length;
                while (i < len) {
                    String filter = this.m_filters[i];
                    sb.append("\"");
                    sb.append(filter);
                    sb.append("\"");
                    if (i < len - 1) {
                        sb.append(",");
                    }
                    ++i;
                }
                sb.append("}));");
                tempLine = tempLine.replace("[Filter]", sb.toString());
            }
            return tempLine;
        }
    }

    public static class UserAgentHandler
    implements ITemplateHandler {
        private static final String IMPORT = "import com.ebay.dsf.test.utils.common.UserAgentsEnum;";
        private String[] m_uas;
        private boolean m_bImport;
        private boolean m_bMethod;

        public UserAgentHandler(String[] uas) {
            this.m_uas = uas;
        }

        @Override
        public boolean accept(String tempLine) {
            if (this.m_uas == null || this.m_uas.length == 0) {
                return false;
            }
            this.m_bImport = tempLine.contains("[UserAgentImport]");
            this.m_bMethod = tempLine.contains("[UserAgent]");
            return this.m_bImport || this.m_bMethod;
        }

        @Override
        public String handle(String tempLine) {
            if (this.m_bImport) {
                tempLine = tempLine.replace("[UserAgentImport]", IMPORT);
            } else if (this.m_bMethod) {
                StringBuilder sb = new StringBuilder();
                sb.append("protected UserAgentsEnum[] getUserAgents(){        return new UserAgentsEnum[]{\n");
                int i = 0;
                int len = this.m_uas.length;
                while (i < len) {
                    String ua = this.m_uas[i];
                    sb.append("UserAgentsEnum.");
                    sb.append(ua);
                    if (i < len - 1) {
                        sb.append(",\n");
                    }
                    ++i;
                }
                sb.append("};\n}");
                tempLine = tempLine.replace("[UserAgent]", sb.toString());
            }
            return tempLine;
        }
    }
}

