/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.embedded.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.vjet.vsf.dervlet.embedded.proxy.AppSpecRule;
import org.eclipse.vjet.vsf.dervlet.embedded.proxy.ProxyRule;

public class ProxyServerConfig {
    private static final String DEFAULT_RULE = "css@**/*@;categoryjs@**/*@;aw@**/*/*.js,**/*/*.swf@;js@**/*@";
    private static final String REALTIME_BUILDER_SERVER_DEFAULT_PORT = "9091";
    private int m_port = 9091;
    private static final String REALTIME_BUILDER_SERVER_DEFAULT_QATE = "true";
    private static final String REALTIME_BUILDER_SERVER_DEFAULT_VIEW_PATH = "Z:\\";
    private static final String REALTIME_BUILDER_PREX = "v4.realtimebuilder.";
    private static final String REALTIME_BUILDER_SERVER_PORT = "v4.realtimebuilder.Port";
    private static final String REALTIME_BUILDER_SERVER_RULES = "v4.realtimebuilder.RULES";
    private static final String REALTIME_BUILDER_SERVER_VIEW_PATH = "v4.realtimebuilder.ViewPath";
    private static final String REALTIME_BUILDER_SERVER_QATE = "v4.realtimebuilder.QATE";
    private static final String REALTIME_BUILDER_SERVER_VIEW_ROOT = "v4.realtimebuilder.ViewRoot";
    private static final String REALTIME_BUILDER_SERVER_JS_APP_SPEC_RULES = "v4.realtimebuilder.JsAppSpecRules";
    private static final String REALTIME_BUILDER_SERVER_CSS_APP_SPEC_RULES = "v4.realtimebuilder.CssAppSpecRules";
    private static final String REALTIME_BUILDER_SERVER_NEED_VERBOSE = "v4.realtimebuilder.NeedVerboseInfo";
    private static final String REALTIME_BUILDER_SERVER_NEED_OBFUSCATION = "v4.realtimebuilder.NeedObfuscation";
    public static final int JS = 0;
    public static final int CSS = 1;
    private static final String TOKEN_SEPARATOR_MAIN = ";";
    private static final String TOKEN_SEPARATOR_FIELD = "@";
    private String m_viewPath = "z:\\";
    private String m_viewRoot;
    private boolean m_isQATE;
    private Map<String, AppSpecRule> m_cssAppSpecRules;
    private Map<String, AppSpecRule> m_jsAppSpecRules;
    private String m_prefsFilePath = null;
    private boolean m_needVerboseInfo = false;
    private boolean m_needObfuscation = false;
    private static ProxyServerConfig m_config = null;
    private List<ProxyRule> m_rules = new ArrayList<ProxyRule>();

    public static ProxyServerConfig getInstance() {
        if (m_config == null) {
            m_config = new ProxyServerConfig();
        }
        return m_config;
    }

    public Map<String, AppSpecRule> getAppSpecRules(int type) {
        switch (type) {
            case 0: {
                if (this.m_jsAppSpecRules == null) {
                    this.m_jsAppSpecRules = new HashMap<String, AppSpecRule>();
                }
                return this.m_jsAppSpecRules;
            }
            case 1: {
                if (this.m_cssAppSpecRules == null) {
                    this.m_cssAppSpecRules = new HashMap<String, AppSpecRule>();
                }
                return this.m_cssAppSpecRules;
            }
        }
        return null;
    }

    public void loadConfig(String prefsFilePath) {
        block13: {
            this.m_prefsFilePath = prefsFilePath;
            Properties props = new Properties();
            InputStream in = null;
            try {
                try {
                    File file = new File(prefsFilePath);
                    if (!file.exists()) {
                        this.m_viewPath = REALTIME_BUILDER_SERVER_DEFAULT_VIEW_PATH;
                        this.m_viewRoot = "";
                        this.m_isQATE = true;
                        this.m_port = Integer.parseInt(REALTIME_BUILDER_SERVER_DEFAULT_PORT);
                        this.m_needVerboseInfo = false;
                        this.m_needObfuscation = false;
                        this.parseConfig(DEFAULT_RULE);
                        this.parseAppSpecs("", 0);
                        this.parseAppSpecs("", 1);
                        break block13;
                    }
                    in = new BufferedInputStream(new FileInputStream(file));
                    props.load(in);
                    this.m_viewPath = props.getProperty(REALTIME_BUILDER_SERVER_VIEW_PATH, REALTIME_BUILDER_SERVER_DEFAULT_VIEW_PATH);
                    this.m_viewRoot = props.getProperty(REALTIME_BUILDER_SERVER_VIEW_ROOT, "");
                    this.m_isQATE = REALTIME_BUILDER_SERVER_DEFAULT_QATE.equals(props.getProperty(REALTIME_BUILDER_SERVER_QATE, REALTIME_BUILDER_SERVER_DEFAULT_QATE));
                    this.m_port = Integer.parseInt(props.getProperty(REALTIME_BUILDER_SERVER_PORT, REALTIME_BUILDER_SERVER_DEFAULT_PORT));
                    this.m_needVerboseInfo = Boolean.parseBoolean(props.getProperty(REALTIME_BUILDER_SERVER_NEED_VERBOSE, "false"));
                    this.m_needObfuscation = Boolean.parseBoolean(props.getProperty(REALTIME_BUILDER_SERVER_NEED_OBFUSCATION, "false"));
                    String rulesString = props.getProperty(REALTIME_BUILDER_SERVER_RULES, DEFAULT_RULE);
                    this.parseConfig(rulesString);
                    String appSpecRules = props.getProperty(REALTIME_BUILDER_SERVER_JS_APP_SPEC_RULES, "");
                    this.parseAppSpecs(appSpecRules, 0);
                    appSpecRules = props.getProperty(REALTIME_BUILDER_SERVER_CSS_APP_SPEC_RULES, "");
                    this.parseAppSpecs(appSpecRules, 1);
                }
                catch (Exception exception) {
                    if (in == null) break block13;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void saveAppSpecConfig() {
        block22: {
            OutputStream out = null;
            InputStream in = null;
            if (this.m_prefsFilePath == null) {
                return;
            }
            try {
                try {
                    File m_prefsFile = new File(this.m_prefsFilePath);
                    if (!m_prefsFile.exists()) {
                        m_prefsFile.createNewFile();
                    }
                    Properties props = new Properties();
                    in = new BufferedInputStream(new FileInputStream(m_prefsFile));
                    props.load(in);
                    in.close();
                    this.saveAppSpec(props, 0);
                    this.saveAppSpec(props, 1);
                    out = new BufferedOutputStream(new FileOutputStream(this.m_prefsFilePath));
                    props.store(out, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (in == null) break block22;
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void saveAppSpec(Properties props, int type) {
        StringBuffer appSpecSettings = new StringBuffer(100);
        Map<String, AppSpecRule> appSpecRules = this.getAppSpecRules(type);
        for (AppSpecRule appSpecRule : appSpecRules.values()) {
            appSpecSettings.append(appSpecRule.toString()).append(TOKEN_SEPARATOR_MAIN);
        }
        int length = appSpecSettings.length();
        String propName = REALTIME_BUILDER_SERVER_CSS_APP_SPEC_RULES;
        if (type == 0) {
            propName = REALTIME_BUILDER_SERVER_JS_APP_SPEC_RULES;
        }
        if (length > 1) {
            props.setProperty(propName, appSpecSettings.deleteCharAt(length - 1).toString());
        }
    }

    private void parseAppSpecs(String appSpecRulesSetting, int type) {
        if (!"".equals(appSpecRulesSetting)) {
            String[] appSpecSettings = appSpecRulesSetting.split(TOKEN_SEPARATOR_MAIN);
            Map<String, AppSpecRule> m_appSpecRules = this.getAppSpecRules(type);
            AppSpecRule appSpecRule = null;
            int i = 0;
            int count = appSpecSettings.length;
            while (i < count) {
                appSpecRule = AppSpecRule.valueOf(appSpecSettings[i]);
                if (appSpecRule != null) {
                    m_appSpecRules.put(appSpecRule.getAppSpecName(), appSpecRule);
                }
                ++i;
            }
        }
    }

    private void parseConfig(String config) {
        StringTokenizer tokens = new StringTokenizer(config, TOKEN_SEPARATOR_MAIN);
        while (tokens.hasMoreTokens()) {
            StringTokenizer fieldTokens = new StringTokenizer(tokens.nextToken(), TOKEN_SEPARATOR_FIELD);
            if (fieldTokens.countTokens() == 3) {
                this.addRule(fieldTokens.nextToken(), fieldTokens.nextToken(), fieldTokens.nextToken());
            }
            if (fieldTokens.countTokens() != 2) continue;
            this.addRule(fieldTokens.nextToken(), fieldTokens.nextToken(), "");
        }
    }

    private ProxyServerConfig() {
        this.addRule("debug", "**/*", "");
        this.addRule("v4js", "**/*", "");
        this.addRule("v4css", "**/*", "");
    }

    public boolean isQATE() {
        return this.m_isQATE;
    }

    public void setQATE(boolean isQATE) {
        this.m_isQATE = isQATE;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public List<ProxyRule> getRules() {
        return this.m_rules;
    }

    public void setRules(List<ProxyRule> rules) {
        this.m_rules = rules;
    }

    public String getViewPath() {
        return this.m_viewPath;
    }

    public void setViewPath(String viewPath) {
        this.m_viewPath = viewPath;
    }

    public String getViewRoot() {
        return this.m_viewRoot;
    }

    public void setViewRoot(String viewRoot) {
        if (viewRoot == null) {
            return;
        }
        if (!viewRoot.endsWith("\\") && !viewRoot.endsWith("/")) {
            viewRoot = String.valueOf(viewRoot) + "\\";
        }
        this.m_viewRoot = viewRoot;
    }

    public void addRule(String resourceName, String includes, String excludes) {
        this.m_rules.add(new ProxyRule(resourceName, includes, excludes));
    }

    public boolean isNeedObfuscation() {
        return this.m_needObfuscation;
    }

    public void setNeedObfuscation(boolean obfuscation) {
        this.m_needObfuscation = obfuscation;
    }

    public boolean isNeedVerboseInfo() {
        return this.m_needVerboseInfo;
    }

    public void setNeedVerboseInfo(boolean verboseInfo) {
        this.m_needVerboseInfo = verboseInfo;
    }
}

