/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.embedded.server;

import java.io.IOException;
import java.io.Writer;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.vjet.vsf.dervlet.CoreDervlet;
import org.eclipse.vjet.vsf.dervlet.DervletSessionEnabler;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServerConfig;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServerErrorHandler;

public class EmbeddedServer {
    protected static final String ADMIN_CONTEXT_PATH = "/dervlet-admin";
    private static Map<String, EmbeddedServer> s_serverInstances = new HashMap<String, EmbeddedServer>(1);
    protected EmbeddedServerConfig m_config;
    protected Server m_server;
    protected ServletContextHandler m_appContext;
    protected ServletContextHandler m_adminContext;
    protected Map<String, Servlet> m_nameToServlet = new HashMap<String, Servlet>(5);
    protected static AtomicReference<String> s_localHostName = new AtomicReference();

    public static EmbeddedServer create() {
        return EmbeddedServer.create(EmbeddedServer.getUniquePort());
    }

    public static EmbeddedServer create(int port) {
        return EmbeddedServer.create(port, null, null);
    }

    public static EmbeddedServer create(String contextPath, String resourceBase) {
        return EmbeddedServer.create(EmbeddedServer.getUniquePort(), contextPath, resourceBase);
    }

    public static EmbeddedServer create(int port, String contextPath, String resourceBase) {
        EmbeddedServerConfig config = new EmbeddedServerConfig(port, contextPath, resourceBase);
        return EmbeddedServer.create(config);
    }

    public static EmbeddedServer create(EmbeddedServerConfig config) {
        if (config == null) {
            throw new RuntimeException("Config must not be null");
        }
        EmbeddedServer server = EmbeddedServer.getServer(config.getOriginalPort());
        if (server != null) {
            return server;
        }
        server = new EmbeddedServer();
        server.init(config);
        return server;
    }

    public EmbeddedServerConfig getConfig() {
        return this.m_config;
    }

    public EmbeddedServer addServletWithMapping(Class<? extends HttpServlet> servletClz, String pathSpec) {
        this.m_appContext.getServletHandler().addServletWithMapping(servletClz, pathSpec);
        return this;
    }

    public EmbeddedServer addDervlet(CoreDervlet dervlet) {
        return this.addDervlet(dervlet, (Map<String, String>)null);
    }

    public EmbeddedServer addDervlet(CoreDervlet dervlet, Map<String, String> initParameters) {
        return this.addDervlet(dervlet, dervlet.getServletName(), initParameters);
    }

    public EmbeddedServer addDervlet(CoreDervlet dervlet, String name) {
        return this.addDervlet(dervlet, name, null);
    }

    public EmbeddedServer addDervlet(CoreDervlet dervlet, String name, Map<String, String> initParameters) {
        this.addServlet(dervlet, name, dervlet.getPath(), initParameters);
        dervlet.setServer(this);
        return this;
    }

    public EmbeddedServer addServlet(Servlet servlet, String name, String path) {
        return this.addServlet(servlet, name, path, null);
    }

    public EmbeddedServer addFilter(Class<? extends Filter> filterClass, String name, String path, Map<String, String> initParameters) {
        FilterHolder holder = new FilterHolder(filterClass);
        holder.setName(name);
        if (initParameters != null) {
            holder.setInitParameters(initParameters);
        }
        this.m_appContext.addFilter(holder, path, EnumSet.of(DispatcherType.REQUEST));
        return this;
    }

    public EmbeddedServer addFilter(Filter filter, String name, String path, Map<String, String> initParameters) {
        FilterHolder holder = new FilterHolder(filter);
        holder.setName(name);
        if (initParameters != null) {
            holder.setInitParameters(initParameters);
        }
        this.m_appContext.addFilter(holder, path, EnumSet.of(DispatcherType.REQUEST));
        return this;
    }

    public EmbeddedServer addServlet(Servlet servlet, String name, String path, Map<String, String> initParameters) {
        ServletHolder servletHolder = new ServletHolder(servlet);
        servletHolder.setInitOrder(1);
        servletHolder.setName(name);
        if (initParameters != null) {
            servletHolder.setInitParameters(initParameters);
        }
        ServletHandler servletHandler = this.m_appContext.getServletHandler();
        servletHandler.addServletWithMapping(servletHolder, path);
        this.m_nameToServlet.put(name, servlet);
        return this;
    }

    public EmbeddedServer addServlet(Class<? extends Servlet> servletClass, String name, String path) {
        return this.addServlet(servletClass, name, path, null);
    }

    public EmbeddedServer addServlet(Class<? extends Servlet> servletClass, String name, String path, boolean deferInit) {
        return this.addServlet(servletClass, name, path, null, deferInit);
    }

    public EmbeddedServer addServlet(Class<? extends Servlet> servletClass, String name, String path, Map<String, String> initParameters) {
        return this.addServlet(servletClass, name, path, initParameters, false);
    }

    public EmbeddedServer addServlet(Class<? extends Servlet> servletClass, String name, String path, Map<String, String> initParameters, boolean deferInit) {
        ServletHolder servletHolder = new ServletHolder(servletClass);
        if (!deferInit) {
            servletHolder.setInitOrder(1);
        }
        servletHolder.setName(name);
        if (initParameters != null) {
            servletHolder.setInitParameters(initParameters);
        }
        ServletHandler servletHandler = this.m_appContext.getServletHandler();
        servletHandler.addServletWithMapping(servletHolder, path);
        return this;
    }

    protected ServletHandler getHandler() {
        return this.m_appContext.getServletHandler();
    }

    public Object getServletContextAttribute(String attributeName) {
        Object value = this.getHandler().getServletContext().getAttribute(attributeName);
        return value;
    }

    public void setServletContextAttribute(String attributeName, Object value) {
        this.getHandler().getServletContext().setAttribute(attributeName, value);
    }

    public CoreDervlet getDervlet(String name) {
        Servlet servlet = this.getServlet(name);
        if (servlet instanceof CoreDervlet) {
            return (CoreDervlet)servlet;
        }
        return null;
    }

    public Servlet getServlet(String name) {
        Servlet servlet = this.m_nameToServlet.get(name);
        return servlet;
    }

    public EmbeddedServer start() {
        try {
            this.m_server.start();
            s_serverInstances.put("" + this.m_config.getOriginalPort(), this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't start the server.", e);
        }
        return this;
    }

    public void waitForStartup() {
        int seconds = 10;
        while (seconds > 0 && !this.m_server.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            --seconds;
        }
    }

    public EmbeddedServer stop() {
        try {
            this.m_server.setStopAtShutdown(false);
            this.m_server.stop();
        }
        catch (Exception exception) {}
        s_serverInstances.remove("" + this.m_config.getOriginalPort());
        return this;
    }

    public EmbeddedServer join() {
        try {
            this.m_server.join();
        }
        catch (InterruptedException interruptedException) {}
        return this;
    }

    public void setErrorHandler(final EmbeddedServerErrorHandler error_handler) {
        ErrorHandler jetty_error_handler = new ErrorHandler(){

            protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
                error_handler.setRequest(request);
                if (error_handler.handleError(request, writer, code, message)) {
                    return;
                }
                super.handleErrorPage(request, writer, code, message);
            }
        };
        this.m_appContext.setErrorHandler(jetty_error_handler);
    }

    public ServletContextHandler getAppContext() {
        return this.m_appContext;
    }

    public static String getAdminUrl(int port) {
        return EmbeddedServer.getBaseUrl(port, false, ADMIN_CONTEXT_PATH);
    }

    public String getAdminUrl() {
        return EmbeddedServer.getBaseUrl(this.m_config.getPort(), false, ADMIN_CONTEXT_PATH);
    }

    public String getBaseUrl() {
        return EmbeddedServer.getBaseUrl(this.m_config.getPort());
    }

    public int getPort() {
        return this.m_config.getPort();
    }

    public int getRealServerPort() {
        return this.m_config.getOriginalPort();
    }

    public String getBaseSecureUrl() {
        return EmbeddedServer.getBaseUrl(this.m_config.getSslPort(), true, null);
    }

    public static String getBaseUrl(int port) {
        return EmbeddedServer.getBaseUrl(port, false, null);
    }

    public static String getBaseUrl(int port, boolean secure, String path) {
        StringBuilder buf = new StringBuilder(100);
        if (secure) {
            buf.append("https://");
        } else {
            buf.append("http://");
        }
        buf.append(EmbeddedServer.getLocalHostName(port));
        if (path != null) {
            buf.append(path);
        }
        return buf.toString();
    }

    public static String getLocalHostName(int port) {
        return EmbeddedServer.getLocalHostName() + (port != 80 ? ":" + port : "");
    }

    public static String getLocalHostName() {
        if (s_localHostName.get() == null) {
            try {
                s_localHostName.set(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException unknownHostException) {
                s_localHostName.set("localhost");
            }
        }
        return s_localHostName.get();
    }

    public static void setLocalHostName(String name) {
        while (!s_localHostName.weakCompareAndSet(null, name)) {
            if (s_localHostName.get() == null) continue;
            throw new RuntimeException("EmbeddedServer.setLocalHostName: Can only override local host name once!");
        }
    }

    public static String getAdminContextPath() {
        return ADMIN_CONTEXT_PATH;
    }

    public static EmbeddedServer getServer(int port) {
        return s_serverInstances.get("" + port);
    }

    public static IServletMapping[] getServletMapping(int port) {
        EmbeddedServer server = EmbeddedServer.getServer(port);
        if (server == null) {
            return new IServletMapping[0];
        }
        ServletContextHandler context = server.getAppContext();
        ServletMapping[] jettyServletMappings = context.getServletHandler().getServletMappings();
        if (jettyServletMappings == null || jettyServletMappings.length == 0) {
            return new IServletMapping[0];
        }
        IServletMapping[] servletMappings = new IServletMapping[jettyServletMappings.length];
        int i = 0;
        while (i < jettyServletMappings.length) {
            IServletMapping servletMapping;
            final ServletMapping jettyMapping = jettyServletMappings[i];
            servletMappings[i] = servletMapping = new IServletMapping(){

                @Override
                public String[] getPathSpecs() {
                    return jettyMapping.getPathSpecs();
                }

                @Override
                public String getServletName() {
                    return jettyMapping.getServletName();
                }
            };
            ++i;
        }
        return servletMappings;
    }

    public static int getUniquePort() {
        String portStr = System.getProperty("server.port");
        int port = -1;
        if (portStr == null) {
            port = (int)(Math.random() * 16383.0);
            port += 49152;
        } else {
            port = Integer.parseInt(portStr);
        }
        return port;
    }

    public static String getContextPath(int port) {
        EmbeddedServer server = EmbeddedServer.getServer(port);
        if (server == null) {
            return "";
        }
        ServletContextHandler context = server.getAppContext();
        return context.getContextPath();
    }

    protected int getNextAvailablePort(int initialPort, int tries) {
        int answer = initialPort;
        int i = 1;
        while (i <= tries) {
            try {
                ServerSocket s = new ServerSocket(answer);
                s.close();
                return answer;
            }
            catch (BindException bindException) {
                System.err.println("Attempt " + i + " of " + tries + " failed on port " + answer);
                ++answer;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
            ++i;
        }
        throw new RuntimeException("*** Unable to get port after " + tries + " tries ***");
    }

    protected void init(EmbeddedServerConfig config) {
        int port = this.getNextAvailablePort(config.getPort(), 100);
        config.resetPort(port);
        this.m_config = config;
        this.m_server = new Server(port);
        if (config.getSslEnabled()) {
            this.enableSSL(config);
        }
        this.m_server.setStopAtShutdown(true);
        this.m_server.setSendServerVersion(true);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.m_server.setHandler((Handler)contexts);
        this.m_appContext = new ServletContextHandler((HandlerContainer)contexts, this.m_config.getContextPath(), 1);
        if (this.m_config.isEnableSession()) {
            DervletSessionEnabler.enableDervletSession(this.m_appContext);
        }
        this.m_appContext.setResourceBase(this.m_config.getResourceBase());
        ClassLoader cl = this.m_config.getContextClassLoader();
        this.m_appContext.setClassLoader(cl != null ? cl : Thread.currentThread().getContextClassLoader());
        this.m_adminContext = new ServletContextHandler((HandlerContainer)contexts, ADMIN_CONTEXT_PATH, 1);
        this.m_adminContext.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void enableSSL(EmbeddedServerConfig config) {
        String truststorePassword;
        String truststoreType;
        String truststore;
        String keyPasswd;
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setPort(config.getSslPort());
        String keyStore = config.getSslKeystore();
        if (keyStore != null) {
            sslConnector.setKeystore(keyStore);
        }
        sslConnector.setKeystoreType(config.getKeystoreType());
        sslConnector.setProtocol("SSLv3");
        String passwd = config.getSslPassword();
        if (passwd != null) {
            sslConnector.setPassword(passwd);
        }
        if ((keyPasswd = config.getSslKeyPassword()) != null) {
            sslConnector.setKeyPassword(keyPasswd);
        }
        if (config.getProtocol() != null) {
            sslConnector.setProtocol(config.getProtocol());
        }
        if ((truststore = config.getSslTruststore()) != null) {
            sslConnector.setTruststore(truststore);
        }
        if ((truststoreType = config.getTruststoreType()) != null) {
            sslConnector.setTruststoreType(truststoreType);
        }
        if ((truststorePassword = config.getSslTrustPassword()) != null) {
            sslConnector.setTrustPassword(truststorePassword);
        }
        if (config.isRequireClientAuth()) {
            sslConnector.setNeedClientAuth(true);
        }
        this.m_server.addConnector((Connector)sslConnector);
    }

    public void addAdminServletWithMapping(Class<? extends Servlet> adminServletClass, String path) {
        if (this.m_adminContext != null) {
            this.m_adminContext.getServletHandler().addServletWithMapping(adminServletClass, path);
        }
    }

    public static interface IServletMapping {
        public String getServletName();

        public String[] getPathSpecs();
    }
}

