/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileCopyUtil {
    private static final int BUFFER_SIZE = 1024;

    public static void copyDir(File srcDir, File destDir) throws IOException {
        File[] files;
        File[] fileArray = files = srcDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File srcFile = fileArray[n2];
            if (srcFile.isDirectory()) {
                File childDestDir = FileCopyUtil.createDirCopy(destDir, srcFile.getName());
                FileCopyUtil.copyDir(srcFile, childDestDir);
            } else {
                File childFile = FileCopyUtil.createFileCopy(destDir, srcFile.getName());
                FileCopyUtil.copyFile(srcFile, childFile);
            }
            ++n2;
        }
    }

    public static void copyDir(ZipInputStream zis, File destDir) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                FileCopyUtil.createDirCopy(destDir, entry.getName());
                continue;
            }
            File destFile = FileCopyUtil.createFileCopy(destDir, entry.getName());
            FileCopyUtil.copyFile(zis, destFile);
        }
        zis.close();
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream in = new FileInputStream(srcFile);
        FileCopyUtil.copyFile(in, destFile);
        ((InputStream)in).close();
    }

    public static void copyFile(InputStream in, File destFile) throws IOException {
        FileOutputStream out = new FileOutputStream(destFile);
        long checksum = FileCopyUtil.copy(in, out);
        if (checksum != FileCopyUtil.createChecksum(destFile)) {
            throw new IOException("copied file " + destFile.getAbsolutePath() + " doesn't produce the expected checksum");
        }
        out.flush();
        ((OutputStream)out).close();
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        CRC32 checksum = new CRC32();
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) >= 0) {
            checksum.update(buffer, 0, bytesRead);
            out.write(buffer, 0, bytesRead);
        }
        return checksum.getValue();
    }

    public static long createChecksum(File file) throws IOException {
        int bytesRead;
        FileInputStream in = new FileInputStream(file);
        CRC32 checksum = new CRC32();
        byte[] buffer = new byte[1024];
        while ((bytesRead = ((InputStream)in).read(buffer)) >= 0) {
            checksum.update(buffer, 0, bytesRead);
        }
        ((InputStream)in).close();
        return checksum.getValue();
    }

    public static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileCopyUtil.deleteDir(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        dir.delete();
    }

    private static File createDirCopy(File parentDir, String dirName) {
        File destDir = new File(parentDir, dirName);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return destDir;
    }

    private static File createFileCopy(File parentDir, String dirName) throws IOException {
        File dest = new File(parentDir, dirName);
        if (!dest.exists()) {
            File directParent = dest.getParentFile();
            if (!directParent.exists()) {
                directParent.mkdirs();
            }
            dest.createNewFile();
        }
        return dest;
    }
}

