/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoListSerializedResult;
import org.eclipse.vjet.dsf.serializer.VjoSerializableSerializer;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;

public class VjoListSerializer
extends VjoSerializableSerializer {
    private String m_vjoListUtil = "$lU";

    public String getVjoListUtil() {
        return this.m_vjoListUtil;
    }

    public VjoListSerializer setVjoListUtil(String util) {
        this.m_vjoListUtil = util;
        return this;
    }

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return List.class.isAssignableFrom(type);
    }

    @Override
    protected void preSerialize(Object toSerialize) {
        super.preSerialize(toSerialize);
        VjoSerializationCtx.ctx().setHasVjoList(true);
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        VjoListSerializedResult vjoList = new VjoListSerializedResult();
        vjoList.setVjoId(DsfCtx.ctx().ids().nextJsCompId());
        vjoList.setVjoListUtil(this.getVjoListUtil());
        Class<?> type = obj.getClass();
        if (List.class.isAssignableFrom(type)) {
            List list = (List)obj;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                vjoList.addVjoObject(this.getOwner().serialize(it.next()));
            }
        }
        return vjoList;
    }
}

