/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.spec.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.spec.app.DefaultStateSpec;
import org.eclipse.vjet.dsf.spec.app.IAppSpec;
import org.eclipse.vjet.dsf.spec.app.IStateSpec;
import org.eclipse.vjet.dsf.spec.module.IModuleSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;

public class DefaultAppSpec
implements IAppSpec {
    private String m_name;
    private final Map<String, IStateSpec> m_states = new LinkedHashMap<String, IStateSpec>(6);
    private boolean m_initialized = false;
    private boolean m_supportNonversionedResourceExternalization = false;
    private boolean m_includeJsRuntimeIntoPageJs = false;
    private boolean m_jsPkgOptimization = false;
    private String m_optSlot = null;
    private String m_optCommonSlot = null;
    private String m_optKeyView = null;
    private int m_optVersion = 1;
    private int m_optCommonFactor = 10;
    private Set<IViewSpec> m_optViewsExclude = null;
    protected static final IAppSpec.Option IN_ONLY = IAppSpec.Option.IN_ONLY;
    protected static final IAppSpec.Option OUT_ONLY = IAppSpec.Option.OUT_ONLY;
    protected static final IAppSpec.Option IN_OUT = IAppSpec.Option.IN_OUT;

    public DefaultAppSpec(String name) {
        if (name == null || name.trim().length() == 0) {
            DsfExceptionHelper.chuck((String)"name is null or empty");
        }
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public List<IStateSpec> getAllStateSpecs() {
        this.initialize();
        return new ArrayList<IStateSpec>(this.m_states.values());
    }

    @Override
    public IStateSpec getStateSpec(String name) {
        this.initialize();
        return this.m_states.get(name);
    }

    @Override
    public List<IModuleSpec> getAllInboundModuleSpecs() {
        this.initialize();
        if (this.m_states.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IModuleSpec> list = new ArrayList<IModuleSpec>(6);
        Iterator<IStateSpec> itr = this.m_states.values().iterator();
        while (itr.hasNext()) {
            list.addAll(itr.next().getAllInboundModuleSpecs());
        }
        return list;
    }

    @Override
    public List<IModuleSpec> getAllOutboundModuleSpecs() {
        this.initialize();
        if (this.m_states.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IModuleSpec> list = new ArrayList<IModuleSpec>(6);
        Iterator<IStateSpec> itr = this.m_states.values().iterator();
        while (itr.hasNext()) {
            list.addAll(itr.next().getAllOutboundModuleSpecs());
        }
        return list;
    }

    @Override
    public List<IModuleSpec> getAllModuleSpecs() {
        this.initialize();
        if (this.m_states.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IModuleSpec> list = new ArrayList<IModuleSpec>(6);
        Iterator<IStateSpec> itr = this.m_states.values().iterator();
        while (itr.hasNext()) {
            list.addAll(itr.next().getAllModuleSpecs());
        }
        return list;
    }

    @Override
    public List<IModuleSpec> getModuleSpecs(IAppSpec.Option option) {
        this.initialize();
        if (this.m_states.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IModuleSpec> list = new ArrayList<IModuleSpec>(6);
        Iterator<IStateSpec> itr = this.m_states.values().iterator();
        while (itr.hasNext()) {
            list.addAll(itr.next().getModuleSpecs(option));
        }
        return list;
    }

    @Override
    public List<IViewSpec> getAllViewSpecs() {
        this.initialize();
        List<IModuleSpec> modules = this.getAllOutboundModuleSpecs();
        if (modules == null) {
            return Collections.emptyList();
        }
        ArrayList<IViewSpec> views = new ArrayList<IViewSpec>(modules.size());
        Iterator<IModuleSpec> itr = modules.iterator();
        while (itr.hasNext()) {
            views.addAll(itr.next().getAllViewSpecs());
        }
        return views;
    }

    @Override
    public void touchAll() {
        this.getAllViewSpecs();
    }

    public DefaultStateSpec createStateSpec(String name) {
        DefaultStateSpec stateSpec = new DefaultStateSpec(name);
        this.m_states.put(name, stateSpec);
        return stateSpec;
    }

    private void initialize() {
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        try {
            Class.forName(String.valueOf(this.getClass().getName()) + "$StateSpecs");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            Class.forName(String.valueOf(this.getClass().getName()) + "$ModuleSpecs");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    @Override
    public boolean isSupportNonversionedResourceExternalization() {
        return this.m_supportNonversionedResourceExternalization;
    }

    protected void supportNonversionedResourceExternalization() {
        this.m_supportNonversionedResourceExternalization = true;
    }

    @Override
    public boolean isIncludeJsRuntimeIntoPageJs() {
        return this.m_includeJsRuntimeIntoPageJs;
    }

    protected void includeJsRuntimeIntoPageJs() {
        this.m_includeJsRuntimeIntoPageJs = true;
    }

    public void setJsPkgOptimization(boolean flag) {
        this.m_jsPkgOptimization = flag;
    }

    @Override
    public boolean isJsPkgOptimization() {
        return this.m_jsPkgOptimization;
    }

    @Override
    public String getOptSlot() {
        return this.m_optSlot;
    }

    public void setOptSlot(String slotName) {
        this.m_optSlot = slotName;
    }

    @Override
    public String getOptCommonSlot() {
        return this.m_optCommonSlot;
    }

    public void setOptCommonSlot(String slotName) {
        this.m_optCommonSlot = slotName;
    }

    @Override
    public String getOptKeyView() {
        return this.m_optKeyView;
    }

    public void setOptKeyView(String viewName) {
        this.m_optKeyView = viewName;
    }

    @Override
    public int getOptCommonFactor() {
        return this.m_optCommonFactor;
    }

    public void setOptCommonFactor(int views) {
        this.m_optCommonFactor = views;
    }

    public void addOptViewsExclude(IViewSpec viewSpec) {
        if (viewSpec == null) {
            return;
        }
        if (this.m_optViewsExclude == null) {
            this.m_optViewsExclude = new HashSet<IViewSpec>();
        }
        this.m_optViewsExclude.add(viewSpec);
    }

    @Override
    public Set<IViewSpec> getOptViewsExclude() {
        return this.m_optViewsExclude;
    }

    @Override
    public void clearJsCache() {
    }

    @Override
    public int getOptVersion() {
        return this.m_optVersion;
    }

    public void setOptVersion(int version) {
        this.m_optVersion = version;
    }
}

