/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.Schema;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.HtmlParserOptions;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.util.HtmlBuilder;
import org.eclipse.vjet.dsf.html.dom.util.HtmlBuilderExt;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class HtmlBuilderHelper {
    public static final String REGX_TAG_SKIP = "(<[a-zA-Z_0-9:]+)/([ a-zA-Z_0-9:]+)";

    public static DHtmlDocument parseHtmlFragment(String src) {
        return HtmlBuilderHelper.parseHtmlFragment(src, false, null);
    }

    public static DHtmlDocument parseHtmlFragment(String src, HtmlParserOptions buildOption) {
        if (buildOption == null) {
            return HtmlBuilderHelper.parseHtmlFragment(src);
        }
        return HtmlBuilderHelper.parseHtmlFragment(src, buildOption.isFixDuplicateIds(), buildOption.getSchema(), buildOption);
    }

    public static DHtmlDocument parseHtmlFragment(String src, boolean fixDuplicateIds) {
        return HtmlBuilderHelper.parseHtmlFragment(src, fixDuplicateIds, null);
    }

    public static DHtmlDocument parseHtmlFragment(String src, boolean fixDuplicateIds, Schema schema) {
        return HtmlBuilderHelper.parseHtmlFragment(src, fixDuplicateIds, schema, null);
    }

    private static DHtmlDocument parseHtmlFragment(String src, boolean fixDuplicateIds, Schema schema, HtmlParserOptions buildOption) {
        HtmlBuilder builder;
        String newSrc = src;
        if (buildOption == null) {
            builder = new HtmlBuilder();
        } else {
            if (schema != null && schema != buildOption.getSchema()) {
                throw new DsfRuntimeException("Schema corruption.");
            }
            newSrc = PreProcessHelper.preProcess(src, buildOption.isPreDecode(), buildOption.isPreProcessTagName(), buildOption.isPreProcessUnkownTag(), buildOption.getSchema());
            builder = new HtmlBuilderExt(buildOption);
        }
        if (fixDuplicateIds) {
            builder.setFixDuplicateIds(true);
        }
        Parser parser = new Parser();
        parser.setContentHandler((ContentHandler)builder);
        InputSource is = new InputSource(new StringReader(newSrc));
        try {
            if (schema != null) {
                parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)schema);
            }
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", buildOption == null || !buildOption.isNoDefaultAttr());
            parser.parse(is);
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return builder.getHTMLDocument();
    }

    static class PreProcessHelper {
        private static final String REGX_TAG_SKIP1 = "(<[a-zA-Z_0-9:]+)([ ]*/[ ]+>)";
        private static final Pattern p = Pattern.compile("^[ ]*<([a-zA-Z_0-9:]+)[ |/|>]");

        PreProcessHelper() {
        }

        private static String preProcess(String input, boolean bDecode, boolean bHandleTagName, boolean bHandleUnkown1stTag, Schema schema) {
            String newSrc = input;
            if (bDecode) {
                try {
                    newSrc = URLDecoder.decode(input.replaceAll("\\+", "%2B"), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (bHandleTagName) {
                newSrc = newSrc.replaceAll(REGX_TAG_SKIP1, "$1/>");
                newSrc = newSrc.replaceAll(HtmlBuilderHelper.REGX_TAG_SKIP, "$1 $2");
                if (bHandleUnkown1stTag) {
                    String tag = PreProcessHelper.getFirstTag(newSrc);
                    newSrc = tag == null || schema.getElementType(tag) != null ? newSrc : "<html><body>" + newSrc.replaceAll("<body>", "");
                }
            }
            return newSrc;
        }

        private static String getFirstTag(String s) {
            Matcher m = p.matcher(s);
            if (m.find()) {
                return m.group(1);
            }
            return null;
        }
    }
}

