/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.naming;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.naming.IDsfNamingFamily;
import org.eclipse.vjet.dsf.common.naming.NameStatusCheck;
import org.eclipse.vjet.dsf.common.naming.ParentScopes;
import org.eclipse.vjet.dsf.common.naming.ResolvedNamePath;

public class HtmlIdNamingFamily
implements IDsfNamingFamily,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SCOPE_SEPARATOR = "-";
    public static final String DEFAULT_LOCAL_NAME_SEPARATOR = "-";
    private static Set<String> s_validSeparators = HtmlIdNamingFamily.createValidSeparators();
    private final String m_scopeSeparator;
    private final String m_localNameSeparator;
    private static HtmlIdNamingFamily s_instance = new HtmlIdNamingFamily("-", "-");

    private static Set<String> createValidSeparators() {
        HashSet<String> set = new HashSet<String>();
        set.add(".");
        set.add(":");
        set.add("_");
        set.add("$");
        set.add("#");
        set.add("-");
        return set;
    }

    public static IDsfNamingFamily getInstance() {
        return s_instance;
    }

    protected HtmlIdNamingFamily(String scopeSeparator, String localNameSeparator) {
        if (!s_validSeparators.contains(scopeSeparator)) {
            String m = "invalid scope separator '" + scopeSeparator + "'";
            throw new DsfInvalidNameException(m);
        }
        if (!s_validSeparators.contains(localNameSeparator)) {
            String m = "invalid local name separator '" + localNameSeparator + "'";
            throw new DsfInvalidNameException(m);
        }
        this.m_scopeSeparator = scopeSeparator;
        this.m_localNameSeparator = localNameSeparator;
    }

    @Override
    public String compose(ResolvedNamePath resolvedNamePath) {
        String localName;
        StringBuilder buffer = new StringBuilder();
        ParentScopes scopes = resolvedNamePath.getScopes();
        if (scopes != null) {
            Iterator<String> iter = scopes.iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                buffer.append(name);
                if (!iter.hasNext()) continue;
                buffer.append(this.m_scopeSeparator);
            }
        }
        if ((localName = resolvedNamePath.getLocalName()) != null) {
            buffer.append(this.m_localNameSeparator);
            buffer.append(localName);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    public ResolvedNamePath decomposeName(String fullyQualifiedName) {
        String localName;
        if (fullyQualifiedName == null || fullyQualifiedName.length() == 0) {
            return ResolvedNamePath.EMPTY;
        }
        ParentScopes scopes = new ParentScopes();
        if (fullyQualifiedName.startsWith(this.m_localNameSeparator)) {
            String localName2 = fullyQualifiedName.substring(this.m_localNameSeparator.length());
            return new ResolvedNamePath(scopes, localName2);
        }
        int index = 0;
        if (fullyQualifiedName.startsWith(this.m_scopeSeparator)) {
            ++index;
        }
        while (index < fullyQualifiedName.length()) {
            int sepIndex = fullyQualifiedName.indexOf(this.m_scopeSeparator, index);
            if (sepIndex == -1) break;
            if (index == sepIndex) {
                throw new DsfInvalidNameException("empty scope name");
            }
            String scope = fullyQualifiedName.substring(index, sepIndex);
            scopes.appendScope(scope);
            index = sepIndex + this.m_scopeSeparator.length();
        }
        if (index >= fullyQualifiedName.length()) {
            localName = null;
        } else {
            int sepIndex = fullyQualifiedName.indexOf(this.m_localNameSeparator, index);
            if (sepIndex == -1) {
                if (index == 0) {
                    localName = fullyQualifiedName;
                } else {
                    String scope = fullyQualifiedName.substring(index);
                    scopes.appendScope(scope);
                    localName = null;
                }
            } else {
                if (sepIndex == index) {
                    throw new DsfInvalidNameException("empty scope name");
                }
                String scope = fullyQualifiedName.substring(index, sepIndex);
                scopes.appendScope(scope);
                localName = fullyQualifiedName.substring(sepIndex + this.m_localNameSeparator.length());
            }
        }
        if (scopes.size() <= 0 && localName == null) {
            return ResolvedNamePath.EMPTY;
        }
        return new ResolvedNamePath(scopes, localName);
    }

    @Override
    public NameStatusCheck verifyLocalName(String localName) {
        return this.verifyName(localName);
    }

    @Override
    public NameStatusCheck verifyScopeName(String scopeName) {
        return this.verifyName(scopeName);
    }

    protected NameStatusCheck verifyName(String name) {
        if (name == null) {
            return new NameStatusCheck(false, "name must not be null");
        }
        int size = name.length();
        if (size == 0) {
            return new NameStatusCheck(false, "name must not be empty");
        }
        int i = 0;
        while (i < size) {
            if (this.isUnqualifiedChar(name.charAt(i))) {
                return new NameStatusCheck(false, "Illegal naming char: " + name.charAt(i) + " from name = " + name);
            }
            ++i;
        }
        return NameStatusCheck.OK;
    }

    private boolean isUnqualifiedChar(char c) {
        switch (c) {
            case ' ': 
            case '#': 
            case '$': 
            case '-': 
            case '.': 
            case ':': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

