/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.statistics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;

public class DarwinStatisticsCtx
extends BaseSubCtx {
    public static final String DARWIN_STATISTICS_SUB_CTX = "DARWIN_STATISTICS_SUB_CTX";
    private ConcurrentMap<String, DarwinStatisticsCount> m_componentStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_contentStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_javascriptStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_cssStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_linkStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_imageStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_esfTemplateStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_esfTemplateFailureStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_bizMoStatistics;
    private ConcurrentMap<String, DarwinStatisticsCount> m_bizOpStatistics;

    public static DarwinStatisticsCtx ctx() {
        DarwinStatisticsCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = new DarwinStatisticsCtx();
            DarwinStatisticsCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(DarwinStatisticsCtx context) {
        CtxAssociator.setCtx(context);
    }

    private DarwinStatisticsCtx() {
    }

    public static String getDARWIN_STATISTICS_SUB_CTX() {
        return DARWIN_STATISTICS_SUB_CTX;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getComponentStatistics() {
        if (this.m_componentStatistics == null) {
            this.m_componentStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_componentStatistics;
    }

    public DarwinStatisticsCtx setComponentStatistics(ConcurrentMap<String, DarwinStatisticsCount> stat) {
        this.m_componentStatistics = stat;
        return this;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getContentStatistics() {
        if (this.m_contentStatistics == null) {
            this.m_contentStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_contentStatistics;
    }

    public void setContentStatistics(ConcurrentMap<String, DarwinStatisticsCount> contentStatistics) {
        this.m_contentStatistics = contentStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getCssStatistics() {
        if (this.m_cssStatistics == null) {
            this.m_cssStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_cssStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getEsfTemplateStatistics() {
        if (this.m_esfTemplateStatistics == null) {
            this.m_esfTemplateStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_esfTemplateStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getEsfTemplateFailureStatistics() {
        if (this.m_esfTemplateFailureStatistics == null) {
            this.m_esfTemplateFailureStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_esfTemplateFailureStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getBizMoStatistics() {
        if (this.m_bizMoStatistics == null) {
            this.m_bizMoStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_bizMoStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getBizOpStatistics() {
        if (this.m_bizOpStatistics == null) {
            this.m_bizOpStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_bizOpStatistics;
    }

    public void setCssStatistics(ConcurrentMap<String, DarwinStatisticsCount> cssStatistics) {
        this.m_cssStatistics = cssStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getJavascriptStatistics() {
        if (this.m_javascriptStatistics == null) {
            this.m_javascriptStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_javascriptStatistics;
    }

    public void setJavascriptStatistics(ConcurrentMap<String, DarwinStatisticsCount> javascriptStatistics) {
        this.m_javascriptStatistics = javascriptStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getImageStatistics() {
        if (this.m_imageStatistics == null) {
            this.m_imageStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_imageStatistics;
    }

    public void setImageStatistics(ConcurrentMap<String, DarwinStatisticsCount> imageStatistics) {
        this.m_imageStatistics = imageStatistics;
    }

    public ConcurrentMap<String, DarwinStatisticsCount> getLinkStatistics() {
        if (this.m_linkStatistics == null) {
            this.m_linkStatistics = new ConcurrentHashMap<String, DarwinStatisticsCount>();
        }
        return this.m_linkStatistics;
    }

    public void setLinkStatistics(ConcurrentMap<String, DarwinStatisticsCount> linkStatistics) {
        this.m_linkStatistics = linkStatistics;
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = DarwinStatisticsCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static DarwinStatisticsCtx getCtx() {
            return (DarwinStatisticsCtx)CtxAssociator.getSubCtx(DsfCtx.ctx(), CTX_NAME);
        }

        protected static void setCtx(DarwinStatisticsCtx ctx) {
            CtxAssociator.setSubCtx(DsfCtx.ctx(), CTX_NAME, ctx);
        }
    }

    public static class DarwinStatisticsCount {
        private AtomicLong m_usage = new AtomicLong(0L);
        private AtomicLong m_ref = new AtomicLong(0L);

        public long getUsage() {
            return this.m_usage.get();
        }

        public DarwinStatisticsCount setUsage(long usage) {
            this.m_usage = new AtomicLong(usage);
            return this;
        }

        public DarwinStatisticsCount incrementUsage() {
            this.m_usage.incrementAndGet();
            return this;
        }

        public DarwinStatisticsCount incrementUsage(long inc) {
            this.m_usage.addAndGet(inc);
            return this;
        }

        public long getRef() {
            return this.m_ref.get();
        }

        public DarwinStatisticsCount setRef(long ref) {
            this.m_ref = new AtomicLong(ref);
            return this;
        }

        public DarwinStatisticsCount incrementRef() {
            this.m_ref.incrementAndGet();
            return this;
        }

        public DarwinStatisticsCount incrementRef(long inc) {
            this.m_ref.addAndGet(inc);
            return this;
        }
    }
}

