/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class DCharacterData
extends DNode
implements CharacterData {
    DCharacterData(DDocument document, String data) {
        super(document);
        this.m_nodeValue = data;
    }

    @Override
    public String getData() throws DOMException {
        return this.m_nodeValue;
    }

    @Override
    public void setData(String data) throws DOMException {
        this.m_nodeValue = data;
    }

    @Override
    public int getLength() {
        return this.m_nodeValue == null ? 0 : this.m_nodeValue.length();
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        return this.m_nodeValue.substring(offset, offset + count);
    }

    @Override
    public void appendData(String data) throws DOMException {
        if (this.m_nodeValue == null) {
            this.m_nodeValue = data;
            return;
        }
        this.m_nodeValue = String.valueOf(this.m_nodeValue) + data;
    }

    @Override
    public void insertData(int offset, String middle) throws DOMException {
        String first = this.m_nodeValue.substring(0, offset);
        String last = this.m_nodeValue.substring(offset);
        this.m_nodeValue = String.valueOf(first) + middle + last;
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        String first = this.m_nodeValue.substring(0, offset);
        String last = this.m_nodeValue.substring(offset + count);
        this.m_nodeValue = String.valueOf(first) + last;
    }

    @Override
    public void replaceData(int offset, int count, String middle) throws DOMException {
        if (offset < 0 || offset > this.m_nodeValue.length()) {
            throw new DOMException(1, "offset of " + offset + " is invalid");
        }
        if (count < 0) {
            throw new DOMException(1, "count of " + count + " is invalid, must not be negative");
        }
        String first = this.m_nodeValue.substring(0, offset);
        int endIndex = offset + count;
        String last = endIndex >= this.m_nodeValue.length() ? "" : this.m_nodeValue.substring(endIndex);
        this.m_nodeValue = String.valueOf(first) + middle + last;
    }

    @Override
    public DCharacterData jif(String jif) {
        super.jif(jif);
        return this;
    }
}

