/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDOMImplementationList;
import org.eclipse.vjet.dsf.dom.DDOMImplementationSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

public class DDOMImplementationRegistry {
    private static List<DOMImplementationSource> s_srcs = new ArrayList<DOMImplementationSource>();
    private List<DOMImplementationSource> m_srcs = new ArrayList<DOMImplementationSource>();

    static {
        s_srcs.add(new DDOMImplementationSource());
        DDOMImplementationRegistry.registerImplSource("org.eclipse.vjet.dsf.dom.DDOMImplementationSource");
        DDOMImplementationRegistry.registerImplSource("org.eclipse.vjet.dsf.html.dom.DHtmlDOMImplementationSource");
        DDOMImplementationRegistry.registerImplSource("org.eclipse.vjet.dsf.nb.BmlDOMImplementationSource");
    }

    private static void registerImplSource(String implClassName) {
        try {
            Class<?> clz = Class.forName(implClassName);
            Constructor<?> c = clz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            DOMImplementationSource src = (DOMImplementationSource)c.newInstance(new Object[0]);
            s_srcs.add(src);
        }
        catch (Exception e) {
            System.err.println("Unable to load " + implClassName + " errmsg: " + e.getMessage());
        }
    }

    public static DDOMImplementationRegistry newInstance() {
        DDOMImplementationRegistry reg = new DDOMImplementationRegistry();
        reg.m_srcs.addAll(s_srcs);
        return reg;
    }

    public void addSource(DOMImplementationSource ... srcs) {
        if (srcs == null) {
            this.chuck("Can not add a null source");
        }
        DOMImplementationSource[] dOMImplementationSourceArray = srcs;
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            DOMImplementationSource src = dOMImplementationSourceArray[n2];
            if (src == null) {
                this.chuck("Can not add a null source");
            }
            this.m_srcs.add(src);
            ++n2;
        }
    }

    public void addSource(Collection<DOMImplementationSource> srcs) {
        if (srcs == null) {
            this.chuck("Can not add a null source");
        }
        for (DOMImplementationSource src : srcs) {
            if (src == null) {
                this.chuck("Can not add a null source");
            }
            this.m_srcs.add(src);
        }
    }

    public DOMImplementation getDOMImplementation(String features) {
        for (DOMImplementationSource src : this.m_srcs) {
            DOMImplementation impl = src.getDOMImplementation(features);
            if (impl == null) continue;
            return impl;
        }
        return null;
    }

    public DOMImplementationList getDOMImplementationList(String features) {
        DDOMImplementationList answer = new DDOMImplementationList(new DOMImplementation[0]);
        for (DOMImplementationSource src : this.m_srcs) {
            DOMImplementationList list = src.getDOMImplementationList(features);
            answer.add(list);
        }
        return answer;
    }

    private void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }
}

