/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DElementConstructor;
import org.eclipse.vjet.dsf.dom.DOMTypeEnum;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.DomUtil;
import org.eclipse.vjet.dsf.dom.support.DNamespace;

public class DOM
extends DElementConstructor {
    private static HashMap<String, Constructor<?>> s_elementTypes;
    private static final Class<?>[] s_elemClassSig;
    private static final Object[] EMPTY_ARG;

    static {
        s_elemClassSig = new Class[0];
        EMPTY_ARG = new Object[0];
        DOM.populateElementTypes();
    }

    public static void main(String[] args) {
        DOM dom = new DOM();
        DElement txt = dom.domCreateDynamicElement("text");
        DText text = (DText)((Object)txt);
        System.out.println(text);
    }

    @Override
    public DElement domCreateDynamicElement(String namespaceUri, String possibleQualifiedName) {
        DNamespace ns = DomUtil.getNamespace(namespaceUri, possibleQualifiedName);
        String localName = DomUtil.getUnqualifedName(possibleQualifiedName);
        return this.domCreateDynamicElement(ns, localName);
    }

    @Override
    public DElement domCreateDynamicElement(String unqualifiedName) {
        String tagName = unqualifiedName;
        Constructor<?> cnst = s_elementTypes.get(tagName);
        if (cnst != null) {
            try {
                return (DElement)cnst.newInstance(EMPTY_ARG);
            }
            catch (Exception except) {
                Throwable thrw = except instanceof InvocationTargetException ? ((InvocationTargetException)except).getTargetException() : except;
                throw new IllegalStateException("HTM15 Tag '" + tagName + "' associated with an Element class that failed to construct.\n" + tagName + " with following message: " + thrw.getMessage(), except);
            }
        }
        return new DElement(tagName);
    }

    @Override
    public DElement domCreateDynamicElement(DNamespace namespace, String nonQualifiedTagName) {
        DElement elem = this.domCreateDynamicElement(nonQualifiedTagName);
        elem.setDsfNamespace(namespace);
        return elem;
    }

    @Override
    public DElement domCreateDynamicElement(DDocument owner, String inTagName) {
        DElement e = this.domCreateDynamicElement(inTagName);
        DOM.setOwnerDocument(owner, e);
        return e;
    }

    @Override
    public DElement domCreateDynamicElement(DDocument owner, DNamespace namespace, String inTagName) {
        DElement e = this.domCreateDynamicElement(namespace, inTagName);
        DOM.setOwnerDocument(owner, e);
        return e;
    }

    private static synchronized void populateElementTypes() {
        if (s_elementTypes != null) {
            return;
        }
        s_elementTypes = new HashMap(101);
        for (DOMTypeEnum type : DOMTypeEnum.valueIterable()) {
            DOM.populateElementType(type);
        }
    }

    private static void populateElementType(DOMTypeEnum type) {
        String tagName = type.getName().toLowerCase();
        Class elemClz = type.getTypeClass();
        try {
            Constructor c = elemClz.getConstructor(s_elemClassSig);
            s_elementTypes.put(tagName, c);
        }
        catch (Exception except) {
            throw new RuntimeException("HTM019 OpenXML Error: Could not find proper constructor for " + elemClz.getName() + " for " + tagName, except);
        }
    }
}

