/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.util.DomToRawSaxGenerator;
import org.eclipse.vjet.dsf.dom.util.DomToRawSaxTraceGenerator;
import org.eclipse.vjet.dsf.dom.util.XmlWriter;
import org.eclipse.vjet.dsf.dom.util.XmlWriterCtx;
import org.w3c.dom.Node;

public class XmlWriterHelper {
    public static String asString(Node node) {
        StringWriter sw = new StringWriter(128);
        XmlWriterHelper.write(node, sw);
        return sw.toString();
    }

    public static String asPrettyString(Node node) {
        return XmlWriterHelper.asString(node, (IIndenter)new IIndenter.Pretty());
    }

    public static String asString(Node node, XmlWriterCtx writerOpt) {
        XmlWriterHelper.write(node, writerOpt);
        return writerOpt.getWriter().toString();
    }

    public static String asString(Node node, IIndenter indenter) {
        StringWriter sw = new StringWriter();
        XmlWriterCtx opts = new XmlWriterCtx().setWriter(sw).setIndenter(indenter);
        XmlWriterHelper.write(node, opts);
        return sw.toString();
    }

    public static void write(Node node, Writer writer) {
        XmlWriterHelper.write(node, new XmlWriterCtx().setWriter(writer).setIndenter(IIndenter.COMPACT));
    }

    public static void write(Node node, Writer writer, IIndenter indenter) {
        XmlWriterCtx opts = new XmlWriterCtx().setWriter(writer).setIndenter(indenter);
        XmlWriterHelper.write(node, opts);
    }

    public static void write(Node node, XmlWriterCtx wOptions) {
        XmlStreamWriter writer = new XmlStreamWriter(wOptions.getWriter(), wOptions.getIndenter());
        XmlWriter rawSaxHandler = new XmlWriter((IXmlStreamWriter)writer, wOptions);
        boolean haveInstrumenter = TraceCtx.ctx().haveInstrumenter();
        DomToRawSaxGenerator saxGenerator = haveInstrumenter ? new DomToRawSaxTraceGenerator(rawSaxHandler) : new DomToRawSaxGenerator(rawSaxHandler);
        try {
            saxGenerator.genEvents(node, (IXmlStreamWriter)writer);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] asBytes(Node node, String encoding, IIndenter indenter) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, encoding);
        XmlWriterHelper.write(node, w, indenter);
        return baos.toByteArray();
    }

    public static String asOneLineString(DNode node) {
        StringWriter sw = new StringWriter();
        XmlStreamWriter writer = new XmlStreamWriter((Writer)sw, IIndenter.COMPACT);
        writer.writeStartElement(node.getNodeName());
        IAttributeMap attrs = node.getDsfAttributes();
        for (DAttr attr : attrs) {
            writer.writeAttribute(attr.getNodeName(), attr.getValue());
        }
        return String.valueOf(sw.toString()) + ">";
    }
}

