/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import java.io.StringReader;
import java.util.Stack;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.kernel.util.xml.rt.Sax2DefaultEventHandler;
import org.eclipse.vjet.kernel.util.xml.rt.XmlReaderHelper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlToDsf {
    public static void main(String[] args) {
        String xmlString = "<person age='32'>cool<!-- fonzy is cool--></person>";
        DElement root = XmlToDsf.convertToDsfGraph(xmlString);
        XmlToDsf.out(root.getTagName());
    }

    public static DElement convertToDsfGraph(String xmlString) {
        StringReader reader = new StringReader(xmlString);
        InputSource inputSource = new InputSource(reader);
        Xml2DsfContentHandler h = new Xml2DsfContentHandler();
        try {
            XMLReader xmlReader = XmlReaderHelper.createXmlReader();
            XmlReaderHelper.setDefaultParams((XMLReader)xmlReader, (boolean)true);
            try {
                xmlReader.setErrorHandler((ErrorHandler)((Object)h));
                xmlReader.setContentHandler((ContentHandler)((Object)h));
                xmlReader.setDTDHandler((DTDHandler)((Object)h));
                xmlReader.parse(inputSource);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        DElement root = h.getRoot();
        return root;
    }

    private static void out(Object o) {
    }

    private static class DsfStack
    extends Stack<DNode> {
        private static final long serialVersionUID = 1L;

        private DsfStack() {
        }

        public DNode dpop() {
            return (DNode)this.pop();
        }

        public DNode dpeek() {
            return (DNode)this.peek();
        }
    }

    public static class Xml2DsfContentHandler
    extends Sax2DefaultEventHandler {
        private DsfStack m_stack = new DsfStack();
        private DElement m_root;

        public DElement getRoot() {
            return this.m_root;
        }

        public void comment(char[] ch, int start, int length) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void characters(char[] ch, int start, int length) {
            String str = "";
            int i = start;
            while (i < start + length) {
                if (ch[i] != '\t' && ch[i] != '\n') {
                    str = String.valueOf(str) + ch[i];
                }
                ++i;
            }
            if (str.length() > 0 && !this.m_stack.isEmpty()) {
                DText textNode = new DText(str);
                this.m_stack.dpeek().add(textNode);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            DElement c = new DElement(localName);
            if (this.m_root == null) {
                this.m_root = c;
            }
            if (!this.m_stack.isEmpty()) {
                this.m_stack.dpeek().add(c);
            }
            this.m_stack.push(c);
            int i = 0;
            while (i < attributes.getLength()) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                c.getDsfAttributes().put(attrName, attrValue);
                ++i;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.m_stack.pop();
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

