/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.dali.core.AccessType;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.PersistentType;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.wrappers.ConnectionInfoWrapper;
import org.eclipse.dali.db.wrappers.DatabaseWrapper;
import org.eclipse.dali.db.wrappers.RdbWrapper;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.EntityItemProvider;
import org.eclipse.dali.edit.PersistentTypeItemProvider;
import org.eclipse.dali.ui.views.AttributeOverridesComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.dali.ui.views.TableComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EntityComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private DaliItemProviderAdapterFactory adapterFactory;
    private EditingDomain editingDomain;
    private Entity entity;
    private PersistentType persistentType;
    private ComboViewer accessTypeComboViewer;
    private Combo entityNameCombo;
    private TableComposite tableComposite;
    private AttributeOverridesComposite attributeOverridesComposite;
    private EntityItemProvider entityItemProvider;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private INotifyChangedListener entityListener;
    private INotifyChangedListener persistentTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EntityComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.adapterFactory = adapterFactory;
        this.editingDomain = editingDomain;
        this.entityItemProvider = (EntityItemProvider)adapterFactory.createEntityAdapter();
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout();
    }

    private INotifyChangedListener getEntityListener() {
        if (this.entityListener == null) {
            this.entityListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    switch (notification.getFeatureID(Entity.class)) {
                        case 1: {
                            String name = notification.getNewStringValue();
                            Display.getDefault().syncExec(new Runnable(this, name){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ String val$name;
                                {
                                    this.this$1 = var1_1;
                                    this.val$name = string;
                                }

                                public void run() {
                                    if (this.val$name == null) {
                                        EntityComposite.access$0(1.access$0(this.this$1)).select(0);
                                    } else if (!EntityComposite.access$0(1.access$0(this.this$1)).getText().equals(this.val$name)) {
                                        EntityComposite.access$0(1.access$0(this.this$1)).setText(this.val$name);
                                    }
                                }
                            });
                            break;
                        }
                        case 0: {
                            String defaultName = notification.getNewStringValue();
                            Display.getDefault().syncExec(new Runnable(this, defaultName){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ String val$defaultName;
                                {
                                    this.this$1 = var1_1;
                                    this.val$defaultName = string;
                                }

                                public void run() {
                                    boolean defaultSelected = false;
                                    if (EntityComposite.access$0(1.access$0(this.this$1)).getSelectionIndex() == 0) {
                                        defaultSelected = true;
                                    }
                                    EntityComposite.access$0(1.access$0(this.this$1)).setItem(0, "Default (" + this.val$defaultName + ")");
                                    if (defaultSelected) {
                                        EntityComposite.access$0(1.access$0(this.this$1)).select(0);
                                    }
                                }
                            });
                            break;
                        }
                    }
                }

                static /* synthetic */ EntityComposite access$0(1 var0) {
                    return var0.EntityComposite.this;
                }
            };
        }
        return this.entityListener;
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(PersistentType.class) == 2) {
                        AccessType accessType = (AccessType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, accessType){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ AccessType val$accessType;
                            {
                                this.this$1 = var1_1;
                                this.val$accessType = accessType;
                            }

                            public void run() {
                                if (((StructuredSelection)EntityComposite.access$1(4.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$accessType) {
                                    EntityComposite.access$1(4.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$accessType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ EntityComposite access$0(4 var0) {
                    return var0.EntityComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    private ConnectionListener buildConnectionListener(final ConnectionInfoWrapper connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, ConnectionInfoWrapper info) {
            }

            public void connected(ConnectionInfoWrapper info, Connection connection) {
            }

            public void disconnected(ConnectionInfoWrapper info, Connection connection) {
            }

            public void sharedConnectionAdded(ConnectionInfoWrapper info, Connection connection) {
            }

            public void sharedConnectionRemove(ConnectionInfoWrapper info, Connection connection) {
            }

            public void sharedDatabaseAdded(ConnectionInfoWrapper info, DatabaseWrapper database) {
                if (connectionInfo.equals((RdbWrapper)info)) {
                    EntityComposite.this.populate((EObject)EntityComposite.this.entity);
                }
            }

            public void sharedDatabaseRemove(ConnectionInfoWrapper info, DatabaseWrapper database) {
                connectionInfo.equals((RdbWrapper)info);
            }

            public void onSQLException(ConnectionInfoWrapper info, Connection connection, SQLException exception) {
                connectionInfo.equals((RdbWrapper)info);
            }
        };
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label accessTypeLabel = new Label(composite, 16384);
        accessTypeLabel.setText("Access Type:");
        this.accessTypeComboViewer = this.buildAccessTypeCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.accessTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label entityNameLabel = new Label(composite, 16384);
        entityNameLabel.setText("Name:");
        this.entityNameCombo = this.buildEntityNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.entityNameCombo.setLayoutData((Object)gridData);
        this.tableComposite = new TableComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        this.attributeOverridesComposite = new AttributeOverridesComposite(composite, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.attributeOverridesComposite.setLayoutData(gridData);
    }

    private ComboViewer buildAccessTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(AccessType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (EntityComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    EntityComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)EntityComposite.this.editingDomain, (Object)EntityComposite.this.persistentType, (Object)DaliPackage.eINSTANCE.getPersistentType_AccessType(), (Object)selection.getFirstElement()));
                }
            }
        });
        return viewer;
    }

    private Combo buildEntityNameCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.add("Default ()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EntityComposite.this.populating) {
                    return;
                }
                EntityComposite.this.entityNameCombo.getSelectionIndex();
                String text = ((Combo)e.getSource()).getText();
                if (text.equals(EntityComposite.this.entityNameCombo.getItem(0))) {
                    text = null;
                }
                EntityComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)EntityComposite.this.editingDomain, (Object)EntityComposite.this.entity, (Object)DaliPackage.eINSTANCE.getEntity_SpecifiedName(), (Object)text));
            }
        });
        return combo;
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.entity != null) {
            this.entityItemProvider.removeListener(this.getEntityListener());
            this.entity.eAdapters().remove((Object)this.entityItemProvider);
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
        this.entity = (Entity)model;
        if (this.entity == null) {
            this.attributeOverridesComposite.populate(null);
            return;
        }
        this.persistentType = this.entity.getPersistentType();
        this.entityItemProvider.addListener(this.getEntityListener());
        this.entity.eAdapters().add((Object)this.entityItemProvider);
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.populateGeneralPanel();
        this.populateTablePanel();
        this.attributeOverridesComposite.populate((EObject)this.entity);
        this.populating = false;
    }

    private void populateGeneralPanel() {
        this.accessTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.persistentType.getAccessType()));
        this.entityNameCombo.getSelectionIndex();
        this.entityNameCombo.setItem(0, "Default (" + this.entity.getDefaultName() + ")");
        String entityName = this.entity.getSpecifiedName();
        if (entityName != null) {
            if (!this.entityNameCombo.getText().equals(entityName)) {
                this.entityNameCombo.setText(entityName);
            }
        } else {
            this.entityNameCombo.select(0);
        }
    }

    private void populateTablePanel() {
        ConnectionInfoWrapper connectionInfo = this.entity.getPersistenceProject().getConnectionInfo();
        if (!connectionInfo.isNull()) {
            connectionInfo.addConnectionListener(this.buildConnectionListener(connectionInfo));
        }
        this.tableComposite.populate((EObject)this.entity.getTable());
    }

    public boolean setFocus() {
        super.setFocus();
        return this.entityNameCombo.setFocus();
    }

    public void dispose() {
        this.entityItemProvider.removeListener(this.entityListener);
        super.dispose();
    }

    static /* synthetic */ ComboViewer access$1(EntityComposite entityComposite) {
        return entityComposite.accessTypeComboViewer;
    }
}

