/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.core.JoinColumn;
import org.eclipse.dali.core.JoinTable;
import org.eclipse.dali.core.ManyToMany;
import org.eclipse.dali.db.wrappers.TableWrapper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class JoinColumnDialog
extends Dialog {
    private JoinColumn joinColumn;
    private Combo nameCombo;
    private Combo referencedColumnNameCombo;
    private boolean defaultNameSelected;
    private String selectedName;
    private boolean defaultReferencedColumnNameSelected;
    private String selectedReferencedColumnName;

    JoinColumnDialog(Shell parent, JoinColumn joinColumn) {
        super(parent);
        this.joinColumn = joinColumn;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return "Edit Join Column";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText("Name:");
        GridData gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        this.nameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameCombo.setLayoutData((Object)gridData);
        this.populateNameCombo(this.nameCombo);
        Label referencedColumnNameLabel = new Label(composite, 16384);
        referencedColumnNameLabel.setText("Referenced Column Name:");
        gridData = new GridData();
        referencedColumnNameLabel.setLayoutData((Object)gridData);
        this.referencedColumnNameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.referencedColumnNameCombo.setLayoutData((Object)gridData);
        this.populateReferencedNameCombo(this.referencedColumnNameCombo);
        return composite;
    }

    protected void populateNameCombo(Combo nameCombo) {
        nameCombo.add("Default ( " + this.getJoinColumn().getDefaultName() + ")");
        TableWrapper joinDBTable = ((JoinTable)this.getJoinColumn().getParent()).getDBTable();
        if (joinDBTable != null) {
            Iterator i = joinDBTable.getColumnNames().iterator();
            while (i.hasNext()) {
                nameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedName() != null) {
            nameCombo.setText(this.getJoinColumn().getSpecifiedName());
        } else {
            nameCombo.select(0);
        }
    }

    protected void populateReferencedNameCombo(Combo referencedColumnNameCombo) {
        referencedColumnNameCombo.add("Default ( " + this.getJoinColumn().getDefaultReferencedColumnName() + ")");
        ManyToMany manyToManyMapping = (ManyToMany)((JoinTable)this.getJoinColumn().getParent()).getParent();
        TableWrapper referencedDbTable = manyToManyMapping.getPersistentTypeFlavor().getResolvedDBTable();
        if (referencedDbTable != null) {
            Iterator i = referencedDbTable.getColumnNames().iterator();
            while (i.hasNext()) {
                referencedColumnNameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            referencedColumnNameCombo.setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
        } else {
            referencedColumnNameCombo.select(0);
        }
    }

    protected JoinColumn getJoinColumn() {
        return this.joinColumn;
    }

    protected boolean isDefaultNameSelected() {
        return this.defaultNameSelected;
    }

    protected String getSelectedName() {
        return this.selectedName;
    }

    protected boolean isDefaultReferencedColumnNameSelected() {
        return this.defaultReferencedColumnNameSelected;
    }

    protected String getReferencedColumnName() {
        return this.selectedReferencedColumnName;
    }

    public boolean close() {
        this.defaultNameSelected = this.nameCombo.getSelectionIndex() == 0;
        this.selectedName = this.nameCombo.getText();
        this.defaultReferencedColumnNameSelected = this.referencedColumnNameCombo.getSelectionIndex() == 0;
        this.selectedReferencedColumnName = this.referencedColumnNameCombo.getText();
        return super.close();
    }
}

