/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class AccessType
extends AbstractEnumerator {
    public static final int DEFAULT = 0;
    public static final int PROPERTY = 1;
    public static final int FIELD = 2;
    public static final AccessType DEFAULT_LITERAL = new AccessType(0, "Default", "Default (Property)");
    public static final AccessType PROPERTY_LITERAL = new AccessType(1, "Property", "Property");
    public static final AccessType FIELD_LITERAL = new AccessType(2, "Field", "Field");
    private static final AccessType[] VALUES_ARRAY = new AccessType[]{DEFAULT_LITERAL, PROPERTY_LITERAL, FIELD_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static AccessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_LITERAL;
            }
            case 1: {
                return PROPERTY_LITERAL;
            }
            case 2: {
                return FIELD_LITERAL;
            }
        }
        return null;
    }

    private AccessType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

