/// <reference types="node" resolution-mode="require"/>
import type tsp from 'typescript/lib/protocol.d.js';
import type { CancellationToken } from 'vscode-jsonrpc';
import { CommandTypes } from './tsp-command-types.js';
import { Logger } from './utils/logger.js';
import API from './utils/api.js';
import type { ILogDirectoryProvider } from './tsServer/logDirectoryProvider.js';
import { ExecConfig, ServerResponse, TypeScriptRequestTypes } from './tsServer/requests.js';
import { Trace } from './tsServer/tracer.js';
import type { TypeScriptVersion } from './tsServer/versionProvider.js';
import type { LspClient } from './lsp-client.js';
import type { TsServerLogLevel } from './utils/configuration.js';
export interface TspClientOptions {
    lspClient: LspClient;
    trace: Trace;
    typescriptVersion: TypeScriptVersion;
    logger: Logger;
    logVerbosity: TsServerLogLevel;
    logDirectoryProvider: ILogDirectoryProvider;
    disableAutomaticTypingAcquisition?: boolean;
    maxTsServerMemory?: number;
    npmLocation?: string;
    locale?: string;
    globalPlugins?: string[];
    pluginProbeLocations?: string[];
    onEvent?: (event: tsp.Event) => void;
    onExit?: (exitCode: number | null, signal: NodeJS.Signals | null) => void;
}
export declare class TspClient {
    private options;
    apiVersion: API;
    private primaryTsServer;
    private logger;
    private tsserverLogger;
    private loadingIndicator;
    private tracer;
    constructor(options: TspClientOptions);
    start(): boolean;
    private serviceExited;
    private dispatchEvent;
    shutdown(): void;
    notify(command: CommandTypes.Open, args: tsp.OpenRequestArgs): void;
    notify(command: CommandTypes.Close, args: tsp.FileRequestArgs): void;
    notify(command: CommandTypes.Change, args: tsp.ChangeRequestArgs): void;
    requestGeterr(args: tsp.GeterrRequestArgs, token: CancellationToken): Promise<any>;
    request<K extends keyof TypeScriptRequestTypes>(command: K, args: TypeScriptRequestTypes[K][0], token?: CancellationToken, config?: ExecConfig): Promise<TypeScriptRequestTypes[K][1]>;
    execute(command: keyof TypeScriptRequestTypes, args: any, token?: CancellationToken, config?: ExecConfig): Promise<ServerResponse.Response<tsp.Response>>;
    executeWithoutWaitingForResponse(command: keyof TypeScriptRequestTypes, args: any): void;
    executeAsync(command: keyof TypeScriptRequestTypes, args: tsp.GeterrRequestArgs, token: CancellationToken): Promise<ServerResponse.Response<tsp.Response>>;
    private executeImpl;
    private fatalError;
}
//# sourceMappingURL=tsp-client.d.ts.map