"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
const defaultConfiguration = {
    tags: ['html', 'raw'],
    format: {
        enabled: true,
    },
};
class Configuration {
    constructor() {
        this._format = defaultConfiguration.format;
        this._tags = defaultConfiguration.tags;
    }
    update(config) {
        this._format = Object.assign({}, defaultConfiguration.format, config.format || {});
        this._tags = config.tags || defaultConfiguration.tags;
    }
    get format() { return this._format; }
    get tags() { return this._tags; }
}
exports.Configuration = Configuration;
//# sourceMappingURL=configuration.js.map