import { DebugProtocol } from 'vscode-debugprotocol';
import { IAttachRequestArgs, ILaunchRequestArgs, IStackTraceResponseBody } from '../debugAdapterInterfaces';
import { UrlPathTransformer } from '../transformers/urlPathTransformer';
/**
 * Converts a local path from Code to a path on the target.
 */
export declare class RemotePathTransformer extends UrlPathTransformer {
    private _localRoot;
    private _remoteRoot;
    launch(args: ILaunchRequestArgs): Promise<void>;
    attach(args: IAttachRequestArgs): Promise<void>;
    private init(args);
    scriptParsed(scriptPath: string): Promise<string>;
    stackTraceResponse(response: IStackTraceResponseBody): Promise<void>;
    fixSource(source: DebugProtocol.Source): Promise<void>;
    private shouldMapPaths(remotePath);
    getClientPathFromTargetPath(remotePath: string): string;
    getTargetPathFromClientPath(localPath: string): string;
}
