/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.refactoring;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;

public class CreateFileChange
extends ResourceChange {
    private final URI uri;
    private final String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private final long fStampToRestore;

    public CreateFileChange(URI uri, String source, String encoding) {
        this(uri, source, encoding, -1L);
    }

    public CreateFileChange(URI uri, String source, String encoding, long stampToRestore) {
        Assert.isNotNull((Object)uri, (String)"uri");
        Assert.isNotNull((Object)source, (String)"source");
        this.uri = uri;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        return NLS.bind((String)Messages.edit_CreateFile, (Object)this.uri);
    }

    protected IFile getModifiedResource() {
        return LSPEclipseUtils.getFileHandle(this.uri);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFileInfo jFile = EFS.getStore((URI)this.uri).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError("File " + this.uri + " already exists");
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        block27: {
            block28: {
                pm.beginTask(NLS.bind((String)Messages.edit_CreateFile, (Object)this.uri), 3);
                this.initializeEncoding();
                try {
                    var2_2 = null;
                    var3_5 = null;
                    try {
                        is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                        ifile = LSPEclipseUtils.getFileHandle(this.uri);
                        if (ifile == null) ** GOTO lbl-1000
                        foldersToCreate = new ArrayList<IFolder>();
                        parent = ifile.getParent();
                        while (true) {
                            block26: {
                                if (!parent.exists() && parent.getType() == 2) break block26;
                                Collections.reverse(foldersToCreate);
                                var9_12 = foldersToCreate.iterator();
                                if (true) ** GOTO lbl38
                            }
                            foldersToCreate.add((IFolder)parent);
                            parent = parent.getParent();
                        }
                    }
                    catch (Throwable var3_6) {
                        if (var2_2 == null) {
                            var2_2 = var3_6;
                            throw var2_2;
                        }
                        if (var2_2 == var3_6) throw var2_2;
                        var2_2.addSuppressed(var3_6);
                        throw var2_2;
                    }
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", e.getMessage(), (Throwable)e));
                }
                do {
                    folder = (IFolder)var9_12.next();
                    folder.create(true, false, pm);
lbl38:
                    // 2 sources

                } while (var9_12.hasNext());
                ifile.create((InputStream)is, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
                if (this.fStampToRestore != -1L) {
                    ifile.revertModificationStamp(this.fStampToRestore);
                }
                if (this.fExplicitEncoding) {
                    ifile.setCharset(this.fEncoding, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
                } else {
                    pm.worked(1);
                }
                if (!foldersToCreate.isEmpty()) break block27;
                var12_14 = new DeleteResourceChange(ifile.getFullPath(), true);
                if (is != null) {
                    is.close();
                }
                break block28;
                catch (Throwable var11_17) {
                    throw var11_17;
                }
            }
            pm.done();
            return var12_14;
        }
        ** try [egrp 4[TRYBLOCK] [1 : 288->393)] { 
lbl58:
        // 1 sources

        undoChange = new CompositeChange("Undo " + this.getName());
        undoChange.add((Change)new DeleteResourceChange(ifile.getFullPath(), true));
        Collections.reverse(foldersToCreate);
        var10_16 = foldersToCreate.iterator();
        while (true) {
            if (!var10_16.hasNext()) {
                return undoChange;
            }
            folder = (IFolder)var10_16.next();
            new DeleteResourceChange(folder.getFullPath(), true);
        }
lbl-1000:
        // 1 sources

        {
            file = new File(this.uri);
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            if (!file.createNewFile()) {
                throw new IOException(String.format("Failed to create file '%s'", new Object[]{file}));
            }
            if (is == null) return null;
        }
        is.close();
        return null;
lbl76:
        // 1 sources

        finally {
            if (is == null) {
                pm.done();
                return var12_15;
            }
            is.close();
        }
    }

    private void initializeEncoding() {
        if (this.fEncoding == null) {
            this.fExplicitEncoding = false;
            IFile ifile = this.getModifiedResource();
            if (ifile != null) {
                try {
                    if (ifile.exists()) {
                        this.fEncoding = ifile.getCharset(false);
                        if (this.fEncoding == null) {
                            this.fEncoding = ifile.getCharset(true);
                        } else {
                            this.fExplicitEncoding = true;
                        }
                    } else {
                        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(ifile.getName());
                        if (contentType != null) {
                            this.fEncoding = contentType.getDefaultCharset();
                        }
                        if (this.fEncoding == null) {
                            this.fEncoding = ifile.getCharset(true);
                        }
                    }
                }
                catch (CoreException e) {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            } else {
                this.fEncoding = ResourcesPlugin.getEncoding();
                this.fExplicitEncoding = true;
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

