"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clearComments = exports.parseCssVars = void 0;
// https://github.com/vuejs/core/blob/main/packages/compiler-sfc/src/cssVars.ts#L47-L61
function* parseCssVars(styleContent) {
    styleContent = clearComments(styleContent);
    const reg = /\bv-bind\(\s*(?:'([^']+)'|"([^"]+)"|([^'"][^)]*))\s*\)/g;
    const matchs = styleContent.matchAll(reg);
    for (const match of matchs) {
        if (match.index !== undefined) {
            const matchText = match[1] ?? match[2] ?? match[3];
            if (matchText !== undefined) {
                const offset = match.index + styleContent.slice(match.index).indexOf(matchText);
                yield { offset, text: matchText };
            }
        }
    }
}
exports.parseCssVars = parseCssVars;
function clearComments(css) {
    return css
        .replace(/\/\*([\s\S]*?)\*\//g, match => `/*${' '.repeat(match.length - 4)}*/`)
        .replace(/\/\/([\s\S]*?)\n/g, match => `//${' '.repeat(match.length - 3)}\n`);
}
exports.clearComments = clearComments;
//# sourceMappingURL=parseCssVars.js.map