/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.osgi.framework.Bundle;

public class Utils {
    public static IProject provisionTestProject(String folderName) throws CoreException, IOException {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.wildwebdeveloper.tests"), (IPath)Path.fromPortableString((String)("testProjects/" + folderName)), null);
        File folder = new File((url = FileLocator.toFileURL((URL)url)).getFile());
        if (folder.exists()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testProject" + System.nanoTime());
            project.create(null);
            project.open(null);
            java.nio.file.Path sourceFolder = folder.toPath();
            java.nio.file.Path destFolder = project.getLocation().toFile().toPath();
            Files.walk(sourceFolder, new FileVisitOption[0]).forEach(source -> {
                try {
                    Files.copy(source, destFolder.resolve(sourceFolder.relativize((java.nio.file.Path)source)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            return project;
        }
        return null;
    }

    public static ISourceViewer getViewer(AbstractTextEditor editor) {
        try {
            Method method = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            method.setAccessible(true);
            return (ISourceViewer)method.invoke((Object)editor, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

