/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.dialogfields;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboButtonDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class ComboButtonsDialogField
extends ComboButtonDialogField {
    private static final Image CLEAR_IMAGE = Activator.getImage("clear.gif");
    private final IStringButtonAdapter m_clearAdapter;
    private final boolean m_useClearButton;
    private Button m_clearButton;

    public ComboButtonsDialogField(IStringButtonAdapter browseAdapter, IStringButtonAdapter clearAdapter, int comboFlags, boolean useClearButton) {
        super(browseAdapter, comboFlags);
        this.m_clearAdapter = clearAdapter;
        this.m_useClearButton = useClearButton;
    }

    public Control[] doFillIntoGrid(Composite parent, int columns) {
        Control[] controlArray;
        Button clearButton;
        this.assertEnoughColumns(columns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)ComboButtonsDialogField.gridDataForLabel((int)1));
        Combo combo = this.getComboControl(parent);
        int needColumns = this.getNumberOfControls();
        GridDataFactory.create((Control)combo).fillH().grabH().spanH(columns - needColumns + 1);
        Button browseButton = this.getChangeControl(parent);
        Button button = clearButton = this.m_useClearButton ? this.getClearControl(parent) : null;
        if (this.m_useClearButton) {
            Control[] controlArray2 = new Control[4];
            controlArray2[0] = label;
            controlArray2[1] = combo;
            controlArray2[2] = browseButton;
            controlArray = controlArray2;
            controlArray2[3] = clearButton;
        } else {
            Control[] controlArray3 = new Control[3];
            controlArray3[0] = label;
            controlArray3[1] = combo;
            controlArray = controlArray3;
            controlArray3[2] = browseButton;
        }
        return controlArray;
    }

    public int getNumberOfControls() {
        return this.m_useClearButton ? 4 : 3;
    }

    public Button getClearControl(Composite parent) {
        if (this.m_clearButton == null) {
            this.assertCompositeNotNull(parent);
            this.m_clearButton = new Button(parent, 8);
            this.m_clearButton.setFont(parent.getFont());
            this.m_clearButton.setImage(CLEAR_IMAGE);
            this.m_clearButton.setEnabled(this.isEnabled());
            this.m_clearButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboButtonsDialogField.this.changeClearPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ComboButtonsDialogField.this.changeClearPressed();
                }
            });
        }
        return this.m_clearButton;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.m_clearButton)) {
            this.m_clearButton.setEnabled(this.isEnabled());
        }
    }

    public void changeClearPressed() {
        this.m_clearAdapter.changeControlPressed((DialogField)this);
    }
}

