//
// Copyright (c) 2023 ZettaScale Technology
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
// which is available at https://www.apache.org/licenses/LICENSE-2.0.
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
//
// Contributors:
//   ZettaScale Zenoh Team, <zenoh@zettascale.tech>

#pragma once

#include "api/bytes.hxx"
#include "api/channels.hxx"
#include "api/closures.hxx"
#include "api/config.hxx"
#include "api/encoding.hxx"
#include "api/enums.hxx"
#include "api/hello.hxx"
#include "api/id.hxx"
#include "api/keyexpr.hxx"
#if defined(ZENOHCXX_ZENOHC) || Z_FEATURE_LIVELINESS == 1
#include "api/liveliness.hxx"
#endif
#include "api/logging.hxx"
#include "api/publisher.hxx"
#include "api/query.hxx"
#include "api/query_consolidation.hxx"
#include "api/queryable.hxx"
#include "api/reply.hxx"
#include "api/sample.hxx"
#include "api/scout.hxx"
#include "api/session.hxx"
#include "api/subscriber.hxx"
#include "api/timestamp.hxx"
#if defined(ZENOHCXX_ZENOHC) && defined(Z_FEATURE_UNSTABLE_API)
#include "api/querier.hxx"
#endif
#if defined(Z_FEATURE_SHARED_MEMORY) && defined(Z_FEATURE_UNSTABLE_API)
#include "api/shm/shm.hxx"
#endif
#include "api/ext/serialization.hxx"
#if defined(ZENOHCXX_ZENOHC) && defined(Z_FEATURE_UNSTABLE_API)
#include "api/ext/publication_cache.hxx"
#include "api/ext/querying_subscriber.hxx"
#include "api/matching.hxx"
#endif
