#!/bin/sh

####
####    Test the output of Ted --FontsDocuments
####    For all documents, we check whether the correct font has 
####    been selected, and whether it can be converted to PDF
####

TMP=/tmp/$$.txt
trap "rm -f $TMP" 0

for rtf in *.rtf
do
    base=`basename $rtf .rtf`
    ps=$base.ps
    pdf=$base.pdf

    rtf2ps.sh $rtf $ps

    sed -n						\
	-e	'/^%%BeginProlog:/{q}'			\
	-e	'/^%%DocumentSuppliedFonts:/{q}'	\
	-e	's/^%%DocumentFonts: *//p'		\
	-e	's/^%%+ *//p'				\
		$ps > $TMP
    read used < $TMP

    if grep -q -x "$base" $TMP
    then
	echo $rtf: Uses font $base
    else
	echo $rtf: '##' Does not use $base. Fonts: `cat $TMP`
    fi

    # gs produces error output on stdout
    if  ps2pdf $ps $pdf 1>&2
    then
	: ok
    else
	echo $rtf: '##' Cound not convert $ps to $pdf
	rm -f $pdf
    fi
done
