// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateBindPeerCreatedCode is the HTTP code returned for type CreateBindPeerCreated
const CreateBindPeerCreatedCode int = 201

/*
CreateBindPeerCreated Bind created

swagger:response createBindPeerCreated
*/
type CreateBindPeerCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewCreateBindPeerCreated creates CreateBindPeerCreated with default headers values
func NewCreateBindPeerCreated() *CreateBindPeerCreated {

	return &CreateBindPeerCreated{}
}

// WithPayload adds the payload to the create bind peer created response
func (o *CreateBindPeerCreated) WithPayload(payload *models.Bind) *CreateBindPeerCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind peer created response
func (o *CreateBindPeerCreated) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindPeerCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindPeerAcceptedCode is the HTTP code returned for type CreateBindPeerAccepted
const CreateBindPeerAcceptedCode int = 202

/*
CreateBindPeerAccepted Configuration change accepted and reload requested

swagger:response createBindPeerAccepted
*/
type CreateBindPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewCreateBindPeerAccepted creates CreateBindPeerAccepted with default headers values
func NewCreateBindPeerAccepted() *CreateBindPeerAccepted {

	return &CreateBindPeerAccepted{}
}

// WithReloadID adds the reloadId to the create bind peer accepted response
func (o *CreateBindPeerAccepted) WithReloadID(reloadID string) *CreateBindPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create bind peer accepted response
func (o *CreateBindPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create bind peer accepted response
func (o *CreateBindPeerAccepted) WithPayload(payload *models.Bind) *CreateBindPeerAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind peer accepted response
func (o *CreateBindPeerAccepted) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindPeerBadRequestCode is the HTTP code returned for type CreateBindPeerBadRequest
const CreateBindPeerBadRequestCode int = 400

/*
CreateBindPeerBadRequest Bad request

swagger:response createBindPeerBadRequest
*/
type CreateBindPeerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindPeerBadRequest creates CreateBindPeerBadRequest with default headers values
func NewCreateBindPeerBadRequest() *CreateBindPeerBadRequest {

	return &CreateBindPeerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create bind peer bad request response
func (o *CreateBindPeerBadRequest) WithConfigurationVersion(configurationVersion string) *CreateBindPeerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind peer bad request response
func (o *CreateBindPeerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind peer bad request response
func (o *CreateBindPeerBadRequest) WithPayload(payload *models.Error) *CreateBindPeerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind peer bad request response
func (o *CreateBindPeerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindPeerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindPeerConflictCode is the HTTP code returned for type CreateBindPeerConflict
const CreateBindPeerConflictCode int = 409

/*
CreateBindPeerConflict The specified resource already exists

swagger:response createBindPeerConflict
*/
type CreateBindPeerConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindPeerConflict creates CreateBindPeerConflict with default headers values
func NewCreateBindPeerConflict() *CreateBindPeerConflict {

	return &CreateBindPeerConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create bind peer conflict response
func (o *CreateBindPeerConflict) WithConfigurationVersion(configurationVersion string) *CreateBindPeerConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind peer conflict response
func (o *CreateBindPeerConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind peer conflict response
func (o *CreateBindPeerConflict) WithPayload(payload *models.Error) *CreateBindPeerConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind peer conflict response
func (o *CreateBindPeerConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindPeerConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateBindPeerDefault General Error

swagger:response createBindPeerDefault
*/
type CreateBindPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindPeerDefault creates CreateBindPeerDefault with default headers values
func NewCreateBindPeerDefault(code int) *CreateBindPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateBindPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create bind peer default response
func (o *CreateBindPeerDefault) WithStatusCode(code int) *CreateBindPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create bind peer default response
func (o *CreateBindPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create bind peer default response
func (o *CreateBindPeerDefault) WithConfigurationVersion(configurationVersion string) *CreateBindPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind peer default response
func (o *CreateBindPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind peer default response
func (o *CreateBindPeerDefault) WithPayload(payload *models.Error) *CreateBindPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind peer default response
func (o *CreateBindPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
