// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllHTTPErrorRuleBackendOKCode is the HTTP code returned for type ReplaceAllHTTPErrorRuleBackendOK
const ReplaceAllHTTPErrorRuleBackendOKCode int = 200

/*
ReplaceAllHTTPErrorRuleBackendOK All HTTP Error Rules lines replaced

swagger:response replaceAllHttpErrorRuleBackendOK
*/
type ReplaceAllHTTPErrorRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.HTTPErrorRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleBackendOK creates ReplaceAllHTTPErrorRuleBackendOK with default headers values
func NewReplaceAllHTTPErrorRuleBackendOK() *ReplaceAllHTTPErrorRuleBackendOK {

	return &ReplaceAllHTTPErrorRuleBackendOK{}
}

// WithPayload adds the payload to the replace all Http error rule backend o k response
func (o *ReplaceAllHTTPErrorRuleBackendOK) WithPayload(payload models.HTTPErrorRules) *ReplaceAllHTTPErrorRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http error rule backend o k response
func (o *ReplaceAllHTTPErrorRuleBackendOK) SetPayload(payload models.HTTPErrorRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPErrorRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPErrorRuleBackendAcceptedCode is the HTTP code returned for type ReplaceAllHTTPErrorRuleBackendAccepted
const ReplaceAllHTTPErrorRuleBackendAcceptedCode int = 202

/*
ReplaceAllHTTPErrorRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllHttpErrorRuleBackendAccepted
*/
type ReplaceAllHTTPErrorRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.HTTPErrorRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleBackendAccepted creates ReplaceAllHTTPErrorRuleBackendAccepted with default headers values
func NewReplaceAllHTTPErrorRuleBackendAccepted() *ReplaceAllHTTPErrorRuleBackendAccepted {

	return &ReplaceAllHTTPErrorRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Http error rule backend accepted response
func (o *ReplaceAllHTTPErrorRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceAllHTTPErrorRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Http error rule backend accepted response
func (o *ReplaceAllHTTPErrorRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Http error rule backend accepted response
func (o *ReplaceAllHTTPErrorRuleBackendAccepted) WithPayload(payload models.HTTPErrorRules) *ReplaceAllHTTPErrorRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http error rule backend accepted response
func (o *ReplaceAllHTTPErrorRuleBackendAccepted) SetPayload(payload models.HTTPErrorRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPErrorRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPErrorRuleBackendBadRequestCode is the HTTP code returned for type ReplaceAllHTTPErrorRuleBackendBadRequest
const ReplaceAllHTTPErrorRuleBackendBadRequestCode int = 400

/*
ReplaceAllHTTPErrorRuleBackendBadRequest Bad request

swagger:response replaceAllHttpErrorRuleBackendBadRequest
*/
type ReplaceAllHTTPErrorRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleBackendBadRequest creates ReplaceAllHTTPErrorRuleBackendBadRequest with default headers values
func NewReplaceAllHTTPErrorRuleBackendBadRequest() *ReplaceAllHTTPErrorRuleBackendBadRequest {

	return &ReplaceAllHTTPErrorRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Http error rule backend bad request response
func (o *ReplaceAllHTTPErrorRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPErrorRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Http error rule backend bad request response
func (o *ReplaceAllHTTPErrorRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Http error rule backend bad request response
func (o *ReplaceAllHTTPErrorRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllHTTPErrorRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http error rule backend bad request response
func (o *ReplaceAllHTTPErrorRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllHTTPErrorRuleBackendDefault General Error

swagger:response replaceAllHttpErrorRuleBackendDefault
*/
type ReplaceAllHTTPErrorRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleBackendDefault creates ReplaceAllHTTPErrorRuleBackendDefault with default headers values
func NewReplaceAllHTTPErrorRuleBackendDefault(code int) *ReplaceAllHTTPErrorRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllHTTPErrorRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all HTTP error rule backend default response
func (o *ReplaceAllHTTPErrorRuleBackendDefault) WithStatusCode(code int) *ReplaceAllHTTPErrorRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all HTTP error rule backend default response
func (o *ReplaceAllHTTPErrorRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all HTTP error rule backend default response
func (o *ReplaceAllHTTPErrorRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPErrorRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all HTTP error rule backend default response
func (o *ReplaceAllHTTPErrorRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all HTTP error rule backend default response
func (o *ReplaceAllHTTPErrorRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceAllHTTPErrorRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all HTTP error rule backend default response
func (o *ReplaceAllHTTPErrorRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
