// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllHTTPErrorRuleFrontendOKCode is the HTTP code returned for type ReplaceAllHTTPErrorRuleFrontendOK
const ReplaceAllHTTPErrorRuleFrontendOKCode int = 200

/*
ReplaceAllHTTPErrorRuleFrontendOK All HTTP Error Rules lines replaced

swagger:response replaceAllHttpErrorRuleFrontendOK
*/
type ReplaceAllHTTPErrorRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.HTTPErrorRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleFrontendOK creates ReplaceAllHTTPErrorRuleFrontendOK with default headers values
func NewReplaceAllHTTPErrorRuleFrontendOK() *ReplaceAllHTTPErrorRuleFrontendOK {

	return &ReplaceAllHTTPErrorRuleFrontendOK{}
}

// WithPayload adds the payload to the replace all Http error rule frontend o k response
func (o *ReplaceAllHTTPErrorRuleFrontendOK) WithPayload(payload models.HTTPErrorRules) *ReplaceAllHTTPErrorRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http error rule frontend o k response
func (o *ReplaceAllHTTPErrorRuleFrontendOK) SetPayload(payload models.HTTPErrorRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPErrorRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPErrorRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceAllHTTPErrorRuleFrontendAccepted
const ReplaceAllHTTPErrorRuleFrontendAcceptedCode int = 202

/*
ReplaceAllHTTPErrorRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllHttpErrorRuleFrontendAccepted
*/
type ReplaceAllHTTPErrorRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.HTTPErrorRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleFrontendAccepted creates ReplaceAllHTTPErrorRuleFrontendAccepted with default headers values
func NewReplaceAllHTTPErrorRuleFrontendAccepted() *ReplaceAllHTTPErrorRuleFrontendAccepted {

	return &ReplaceAllHTTPErrorRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Http error rule frontend accepted response
func (o *ReplaceAllHTTPErrorRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllHTTPErrorRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Http error rule frontend accepted response
func (o *ReplaceAllHTTPErrorRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Http error rule frontend accepted response
func (o *ReplaceAllHTTPErrorRuleFrontendAccepted) WithPayload(payload models.HTTPErrorRules) *ReplaceAllHTTPErrorRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http error rule frontend accepted response
func (o *ReplaceAllHTTPErrorRuleFrontendAccepted) SetPayload(payload models.HTTPErrorRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPErrorRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPErrorRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceAllHTTPErrorRuleFrontendBadRequest
const ReplaceAllHTTPErrorRuleFrontendBadRequestCode int = 400

/*
ReplaceAllHTTPErrorRuleFrontendBadRequest Bad request

swagger:response replaceAllHttpErrorRuleFrontendBadRequest
*/
type ReplaceAllHTTPErrorRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleFrontendBadRequest creates ReplaceAllHTTPErrorRuleFrontendBadRequest with default headers values
func NewReplaceAllHTTPErrorRuleFrontendBadRequest() *ReplaceAllHTTPErrorRuleFrontendBadRequest {

	return &ReplaceAllHTTPErrorRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Http error rule frontend bad request response
func (o *ReplaceAllHTTPErrorRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPErrorRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Http error rule frontend bad request response
func (o *ReplaceAllHTTPErrorRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Http error rule frontend bad request response
func (o *ReplaceAllHTTPErrorRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllHTTPErrorRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http error rule frontend bad request response
func (o *ReplaceAllHTTPErrorRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllHTTPErrorRuleFrontendDefault General Error

swagger:response replaceAllHttpErrorRuleFrontendDefault
*/
type ReplaceAllHTTPErrorRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPErrorRuleFrontendDefault creates ReplaceAllHTTPErrorRuleFrontendDefault with default headers values
func NewReplaceAllHTTPErrorRuleFrontendDefault(code int) *ReplaceAllHTTPErrorRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllHTTPErrorRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all HTTP error rule frontend default response
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) WithStatusCode(code int) *ReplaceAllHTTPErrorRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all HTTP error rule frontend default response
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all HTTP error rule frontend default response
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPErrorRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all HTTP error rule frontend default response
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all HTTP error rule frontend default response
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllHTTPErrorRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all HTTP error rule frontend default response
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPErrorRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
