// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllLogTargetBackendOKCode is the HTTP code returned for type GetAllLogTargetBackendOK
const GetAllLogTargetBackendOKCode int = 200

/*
GetAllLogTargetBackendOK Successful operation

swagger:response getAllLogTargetBackendOK
*/
type GetAllLogTargetBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewGetAllLogTargetBackendOK creates GetAllLogTargetBackendOK with default headers values
func NewGetAllLogTargetBackendOK() *GetAllLogTargetBackendOK {

	return &GetAllLogTargetBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all log target backend o k response
func (o *GetAllLogTargetBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target backend o k response
func (o *GetAllLogTargetBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target backend o k response
func (o *GetAllLogTargetBackendOK) WithPayload(payload models.LogTargets) *GetAllLogTargetBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target backend o k response
func (o *GetAllLogTargetBackendOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllLogTargetBackendDefault General Error

swagger:response getAllLogTargetBackendDefault
*/
type GetAllLogTargetBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllLogTargetBackendDefault creates GetAllLogTargetBackendDefault with default headers values
func NewGetAllLogTargetBackendDefault(code int) *GetAllLogTargetBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllLogTargetBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all log target backend default response
func (o *GetAllLogTargetBackendDefault) WithStatusCode(code int) *GetAllLogTargetBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all log target backend default response
func (o *GetAllLogTargetBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all log target backend default response
func (o *GetAllLogTargetBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target backend default response
func (o *GetAllLogTargetBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target backend default response
func (o *GetAllLogTargetBackendDefault) WithPayload(payload *models.Error) *GetAllLogTargetBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target backend default response
func (o *GetAllLogTargetBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
