// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteServerPeerAcceptedCode is the HTTP code returned for type DeleteServerPeerAccepted
const DeleteServerPeerAcceptedCode int = 202

/*
DeleteServerPeerAccepted Configuration change accepted and reload requested

swagger:response deleteServerPeerAccepted
*/
type DeleteServerPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteServerPeerAccepted creates DeleteServerPeerAccepted with default headers values
func NewDeleteServerPeerAccepted() *DeleteServerPeerAccepted {

	return &DeleteServerPeerAccepted{}
}

// WithReloadID adds the reloadId to the delete server peer accepted response
func (o *DeleteServerPeerAccepted) WithReloadID(reloadID string) *DeleteServerPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete server peer accepted response
func (o *DeleteServerPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteServerPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteServerPeerNoContentCode is the HTTP code returned for type DeleteServerPeerNoContent
const DeleteServerPeerNoContentCode int = 204

/*
DeleteServerPeerNoContent Server deleted

swagger:response deleteServerPeerNoContent
*/
type DeleteServerPeerNoContent struct {
}

// NewDeleteServerPeerNoContent creates DeleteServerPeerNoContent with default headers values
func NewDeleteServerPeerNoContent() *DeleteServerPeerNoContent {

	return &DeleteServerPeerNoContent{}
}

// WriteResponse to the client
func (o *DeleteServerPeerNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteServerPeerNotFoundCode is the HTTP code returned for type DeleteServerPeerNotFound
const DeleteServerPeerNotFoundCode int = 404

/*
DeleteServerPeerNotFound The specified resource was not found

swagger:response deleteServerPeerNotFound
*/
type DeleteServerPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerPeerNotFound creates DeleteServerPeerNotFound with default headers values
func NewDeleteServerPeerNotFound() *DeleteServerPeerNotFound {

	return &DeleteServerPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete server peer not found response
func (o *DeleteServerPeerNotFound) WithConfigurationVersion(configurationVersion string) *DeleteServerPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server peer not found response
func (o *DeleteServerPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server peer not found response
func (o *DeleteServerPeerNotFound) WithPayload(payload *models.Error) *DeleteServerPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server peer not found response
func (o *DeleteServerPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteServerPeerDefault General Error

swagger:response deleteServerPeerDefault
*/
type DeleteServerPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerPeerDefault creates DeleteServerPeerDefault with default headers values
func NewDeleteServerPeerDefault(code int) *DeleteServerPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteServerPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete server peer default response
func (o *DeleteServerPeerDefault) WithStatusCode(code int) *DeleteServerPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete server peer default response
func (o *DeleteServerPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete server peer default response
func (o *DeleteServerPeerDefault) WithConfigurationVersion(configurationVersion string) *DeleteServerPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server peer default response
func (o *DeleteServerPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server peer default response
func (o *DeleteServerPeerDefault) WithPayload(payload *models.Error) *DeleteServerPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server peer default response
func (o *DeleteServerPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
