// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetOneSpoeFileOKCode is the HTTP code returned for type GetOneSpoeFileOK
const GetOneSpoeFileOKCode int = 200

/*
GetOneSpoeFileOK Successful operation

swagger:response getOneSpoeFileOK
*/
type GetOneSpoeFileOK struct {
	/*Spoe configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *GetOneSpoeFileOKBody `json:"body,omitempty"`
}

// NewGetOneSpoeFileOK creates GetOneSpoeFileOK with default headers values
func NewGetOneSpoeFileOK() *GetOneSpoeFileOK {

	return &GetOneSpoeFileOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get one spoe file o k response
func (o *GetOneSpoeFileOK) WithConfigurationVersion(configurationVersion string) *GetOneSpoeFileOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get one spoe file o k response
func (o *GetOneSpoeFileOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get one spoe file o k response
func (o *GetOneSpoeFileOK) WithPayload(payload *GetOneSpoeFileOKBody) *GetOneSpoeFileOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get one spoe file o k response
func (o *GetOneSpoeFileOK) SetPayload(payload *GetOneSpoeFileOKBody) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetOneSpoeFileOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetOneSpoeFileNotFoundCode is the HTTP code returned for type GetOneSpoeFileNotFound
const GetOneSpoeFileNotFoundCode int = 404

/*
GetOneSpoeFileNotFound The specified resource was not found

swagger:response getOneSpoeFileNotFound
*/
type GetOneSpoeFileNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetOneSpoeFileNotFound creates GetOneSpoeFileNotFound with default headers values
func NewGetOneSpoeFileNotFound() *GetOneSpoeFileNotFound {

	return &GetOneSpoeFileNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get one spoe file not found response
func (o *GetOneSpoeFileNotFound) WithConfigurationVersion(configurationVersion string) *GetOneSpoeFileNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get one spoe file not found response
func (o *GetOneSpoeFileNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get one spoe file not found response
func (o *GetOneSpoeFileNotFound) WithPayload(payload *models.Error) *GetOneSpoeFileNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get one spoe file not found response
func (o *GetOneSpoeFileNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetOneSpoeFileNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetOneSpoeFileDefault General Error

swagger:response getOneSpoeFileDefault
*/
type GetOneSpoeFileDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetOneSpoeFileDefault creates GetOneSpoeFileDefault with default headers values
func NewGetOneSpoeFileDefault(code int) *GetOneSpoeFileDefault {
	if code <= 0 {
		code = 500
	}

	return &GetOneSpoeFileDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get one spoe file default response
func (o *GetOneSpoeFileDefault) WithStatusCode(code int) *GetOneSpoeFileDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get one spoe file default response
func (o *GetOneSpoeFileDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get one spoe file default response
func (o *GetOneSpoeFileDefault) WithConfigurationVersion(configurationVersion string) *GetOneSpoeFileDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get one spoe file default response
func (o *GetOneSpoeFileDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get one spoe file default response
func (o *GetOneSpoeFileDefault) WithPayload(payload *models.Error) *GetOneSpoeFileDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get one spoe file default response
func (o *GetOneSpoeFileDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetOneSpoeFileDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
