// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package table

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateTableCreatedCode is the HTTP code returned for type CreateTableCreated
const CreateTableCreatedCode int = 201

/*
CreateTableCreated Table created

swagger:response createTableCreated
*/
type CreateTableCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Table `json:"body,omitempty"`
}

// NewCreateTableCreated creates CreateTableCreated with default headers values
func NewCreateTableCreated() *CreateTableCreated {

	return &CreateTableCreated{}
}

// WithPayload adds the payload to the create table created response
func (o *CreateTableCreated) WithPayload(payload *models.Table) *CreateTableCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create table created response
func (o *CreateTableCreated) SetPayload(payload *models.Table) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTableCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTableAcceptedCode is the HTTP code returned for type CreateTableAccepted
const CreateTableAcceptedCode int = 202

/*
CreateTableAccepted Configuration change accepted and reload requested

swagger:response createTableAccepted
*/
type CreateTableAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Table `json:"body,omitempty"`
}

// NewCreateTableAccepted creates CreateTableAccepted with default headers values
func NewCreateTableAccepted() *CreateTableAccepted {

	return &CreateTableAccepted{}
}

// WithReloadID adds the reloadId to the create table accepted response
func (o *CreateTableAccepted) WithReloadID(reloadID string) *CreateTableAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create table accepted response
func (o *CreateTableAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create table accepted response
func (o *CreateTableAccepted) WithPayload(payload *models.Table) *CreateTableAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create table accepted response
func (o *CreateTableAccepted) SetPayload(payload *models.Table) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTableAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTableBadRequestCode is the HTTP code returned for type CreateTableBadRequest
const CreateTableBadRequestCode int = 400

/*
CreateTableBadRequest Bad request

swagger:response createTableBadRequest
*/
type CreateTableBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTableBadRequest creates CreateTableBadRequest with default headers values
func NewCreateTableBadRequest() *CreateTableBadRequest {

	return &CreateTableBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create table bad request response
func (o *CreateTableBadRequest) WithConfigurationVersion(configurationVersion string) *CreateTableBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create table bad request response
func (o *CreateTableBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create table bad request response
func (o *CreateTableBadRequest) WithPayload(payload *models.Error) *CreateTableBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create table bad request response
func (o *CreateTableBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTableBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTableConflictCode is the HTTP code returned for type CreateTableConflict
const CreateTableConflictCode int = 409

/*
CreateTableConflict The specified resource already exists

swagger:response createTableConflict
*/
type CreateTableConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTableConflict creates CreateTableConflict with default headers values
func NewCreateTableConflict() *CreateTableConflict {

	return &CreateTableConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create table conflict response
func (o *CreateTableConflict) WithConfigurationVersion(configurationVersion string) *CreateTableConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create table conflict response
func (o *CreateTableConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create table conflict response
func (o *CreateTableConflict) WithPayload(payload *models.Error) *CreateTableConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create table conflict response
func (o *CreateTableConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTableConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateTableDefault General Error

swagger:response createTableDefault
*/
type CreateTableDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTableDefault creates CreateTableDefault with default headers values
func NewCreateTableDefault(code int) *CreateTableDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateTableDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create table default response
func (o *CreateTableDefault) WithStatusCode(code int) *CreateTableDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create table default response
func (o *CreateTableDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create table default response
func (o *CreateTableDefault) WithConfigurationVersion(configurationVersion string) *CreateTableDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create table default response
func (o *CreateTableDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create table default response
func (o *CreateTableDefault) WithPayload(payload *models.Error) *CreateTableDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create table default response
func (o *CreateTableDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTableDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
