// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/service.proto

#include "google/cloud/automl/v1/internal/auto_ml_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace automl_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AutoMlTracingStub::AutoMlTracingStub(std::shared_ptr<AutoMlStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncCreateDataset(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::CreateDatasetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "CreateDataset");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateDataset(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::CreateDataset(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::CreateDatasetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "CreateDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDataset(context, options, request));
}

StatusOr<google::cloud::automl::v1::Dataset> AutoMlTracingStub::GetDataset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::GetDatasetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "GetDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDataset(context, options, request));
}

StatusOr<google::cloud::automl::v1::ListDatasetsResponse>
AutoMlTracingStub::ListDatasets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::ListDatasetsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ListDatasets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDatasets(context, options, request));
}

StatusOr<google::cloud::automl::v1::Dataset> AutoMlTracingStub::UpdateDataset(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::UpdateDatasetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "UpdateDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateDataset(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncDeleteDataset(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::DeleteDatasetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "DeleteDataset");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteDataset(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::DeleteDataset(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::DeleteDatasetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "DeleteDataset");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDataset(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncImportData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::ImportDataRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ImportData");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncImportData(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::ImportData(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::ImportDataRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ImportData");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ImportData(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncExportData(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::ExportDataRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ExportData");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncExportData(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::ExportData(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::ExportDataRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ExportData");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportData(context, options, request));
}

StatusOr<google::cloud::automl::v1::AnnotationSpec>
AutoMlTracingStub::GetAnnotationSpec(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::GetAnnotationSpecRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl",
                                     "GetAnnotationSpec");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetAnnotationSpec(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncCreateModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::CreateModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "CreateModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::CreateModel(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::CreateModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "CreateModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateModel(context, options, request));
}

StatusOr<google::cloud::automl::v1::Model> AutoMlTracingStub::GetModel(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::GetModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "GetModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetModel(context, options, request));
}

StatusOr<google::cloud::automl::v1::ListModelsResponse>
AutoMlTracingStub::ListModels(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::ListModelsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ListModels");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListModels(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncDeleteModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::DeleteModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "DeleteModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::DeleteModel(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::DeleteModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "DeleteModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteModel(context, options, request));
}

StatusOr<google::cloud::automl::v1::Model> AutoMlTracingStub::UpdateModel(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::UpdateModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "UpdateModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncDeployModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::DeployModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "DeployModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeployModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::DeployModel(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::DeployModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "DeployModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeployModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncUndeployModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::UndeployModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "UndeployModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUndeployModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::UndeployModel(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::UndeployModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "UndeployModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UndeployModel(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncExportModel(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::automl::v1::ExportModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ExportModel");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncExportModel(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AutoMlTracingStub::ExportModel(
    grpc::ClientContext& context, Options options,
    google::cloud::automl::v1::ExportModelRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl", "ExportModel");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportModel(context, options, request));
}

StatusOr<google::cloud::automl::v1::ModelEvaluation>
AutoMlTracingStub::GetModelEvaluation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::GetModelEvaluationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl",
                                     "GetModelEvaluation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetModelEvaluation(context, options, request));
}

StatusOr<google::cloud::automl::v1::ListModelEvaluationsResponse>
AutoMlTracingStub::ListModelEvaluations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::automl::v1::ListModelEvaluationsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.automl.v1.AutoMl",
                                     "ListModelEvaluations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListModelEvaluations(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AutoMlTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AutoMlTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AutoMlStub> MakeAutoMlTracingStub(
    std::shared_ptr<AutoMlStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AutoMlTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_v1_internal
}  // namespace cloud
}  // namespace google
