// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#include "google/cloud/domains/v1/internal/domains_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace domains_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DomainsTracingStub::DomainsTracingStub(std::shared_ptr<DomainsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::domains::v1::SearchDomainsResponse>
DomainsTracingStub::SearchDomains(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::SearchDomainsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "SearchDomains");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SearchDomains(context, options, request));
}

StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
DomainsTracingStub::RetrieveRegisterParameters(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "RetrieveRegisterParameters");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->RetrieveRegisterParameters(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncRegisterDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::RegisterDomainRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "RegisterDomain");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncRegisterDomain(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> DomainsTracingStub::RegisterDomain(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::RegisterDomainRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "RegisterDomain");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RegisterDomain(context, options, request));
}

StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
DomainsTracingStub::RetrieveTransferParameters(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::RetrieveTransferParametersRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "RetrieveTransferParameters");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->RetrieveTransferParameters(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncTransferDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::TransferDomainRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "TransferDomain");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncTransferDomain(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> DomainsTracingStub::TransferDomain(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::TransferDomainRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "TransferDomain");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TransferDomain(context, options, request));
}

StatusOr<google::cloud::domains::v1::ListRegistrationsResponse>
DomainsTracingStub::ListRegistrations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::ListRegistrationsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ListRegistrations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListRegistrations(context, options, request));
}

StatusOr<google::cloud::domains::v1::Registration>
DomainsTracingStub::GetRegistration(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::GetRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "GetRegistration");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRegistration(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncUpdateRegistration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::UpdateRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "UpdateRegistration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateRegistration(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> DomainsTracingStub::UpdateRegistration(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::UpdateRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "UpdateRegistration");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateRegistration(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncConfigureManagementSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ConfigureManagementSettings");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncConfigureManagementSettings(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DomainsTracingStub::ConfigureManagementSettings(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ConfigureManagementSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ConfigureManagementSettings(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncConfigureDnsSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ConfigureDnsSettings");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncConfigureDnsSettings(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DomainsTracingStub::ConfigureDnsSettings(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ConfigureDnsSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ConfigureDnsSettings(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncConfigureContactSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::ConfigureContactSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ConfigureContactSettings");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncConfigureContactSettings(cq, context,
                                                 std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
DomainsTracingStub::ConfigureContactSettings(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::ConfigureContactSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ConfigureContactSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ConfigureContactSettings(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncExportRegistration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::ExportRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ExportRegistration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncExportRegistration(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> DomainsTracingStub::ExportRegistration(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::ExportRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ExportRegistration");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ExportRegistration(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncDeleteRegistration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::domains::v1::DeleteRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "DeleteRegistration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteRegistration(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> DomainsTracingStub::DeleteRegistration(
    grpc::ClientContext& context, Options options,
    google::cloud::domains::v1::DeleteRegistrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "DeleteRegistration");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteRegistration(context, options, request));
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsTracingStub::RetrieveAuthorizationCode(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "RetrieveAuthorizationCode");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->RetrieveAuthorizationCode(context, options, request));
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsTracingStub::ResetAuthorizationCode(
    grpc::ClientContext& context, Options const& options,
    google::cloud::domains::v1::ResetAuthorizationCodeRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.domains.v1.Domains",
                                     "ResetAuthorizationCode");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ResetAuthorizationCode(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
DomainsTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> DomainsTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<DomainsStub> MakeDomainsTracingStub(
    std::shared_ptr<DomainsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<DomainsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1_internal
}  // namespace cloud
}  // namespace google
