// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVILEGEDACCESSMANAGER_V1_PRIVILEGED_ACCESS_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVILEGEDACCESSMANAGER_V1_PRIVILEGED_ACCESS_MANAGER_CLIENT_H

#include "google/cloud/privilegedaccessmanager/v1/privileged_access_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// This API allows customers to manage temporary, request based privileged
/// access to their resources.
///
/// It defines the following resource model:
///
/// * A collection of `Entitlement` resources. An entitlement allows configuring
///   (among other things):
///
///   * Some kind of privileged access that users can request.
///   * A set of users called _requesters_ who can request this access.
///   * A maximum duration for which the access can be requested.
///   * An optional approval workflow which must be satisfied before access is
///     granted.
///
/// * A collection of `Grant` resources. A grant is a request by a requester to
///   get the privileged access specified in an entitlement for some duration.
///
///   After the approval workflow as specified in the entitlement is satisfied,
///   the specified access is given to the requester. The access is
///   automatically taken back after the requested duration is over.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class PrivilegedAccessManagerClient {
 public:
  explicit PrivilegedAccessManagerClient(
      std::shared_ptr<PrivilegedAccessManagerConnection> connection,
      Options opts = {});
  ~PrivilegedAccessManagerClient();

  ///@{
  /// @name Copy and move support
  PrivilegedAccessManagerClient(PrivilegedAccessManagerClient const&) = default;
  PrivilegedAccessManagerClient& operator=(
      PrivilegedAccessManagerClient const&) = default;
  PrivilegedAccessManagerClient(PrivilegedAccessManagerClient&&) = default;
  PrivilegedAccessManagerClient& operator=(PrivilegedAccessManagerClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(PrivilegedAccessManagerClient const& a,
                         PrivilegedAccessManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(PrivilegedAccessManagerClient const& a,
                         PrivilegedAccessManagerClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// CheckOnboardingStatus reports the onboarding status for a
  /// project/folder/organization. Any findings reported by this API need to be
  /// fixed before PAM can be used on the resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L333}
  /// [google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L349}
  ///
  // clang-format on
  StatusOr<
      google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse>
  CheckOnboardingStatus(google::cloud::privilegedaccessmanager::v1::
                            CheckOnboardingStatusRequest const& request,
                        Options opts = {});

  // clang-format off
  ///
  /// Lists entitlements in a given project/folder/organization and location.
  ///
  /// @param parent  Required. The parent which owns the entitlement resources.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L606}
  ///
  // clang-format on
  StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
  ListEntitlements(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists entitlements in a given project/folder/organization and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L606}
  ///
  // clang-format on
  StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
  ListEntitlements(
      google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// `SearchEntitlements` returns entitlements on which the caller has the
  /// specified access.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L642}
  ///
  // clang-format on
  StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
  SearchEntitlements(
      google::cloud::privilegedaccessmanager::v1::SearchEntitlementsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single entitlement.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Entitlement])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L691}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
  GetEntitlement(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single entitlement.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Entitlement])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L691}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
  GetEntitlement(
      google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new entitlement in a given project/folder/organization and
  /// location.
  ///
  /// @param parent  Required. Name of the parent resource for the entitlement.
  ///  Possible formats:
  ///  @n
  ///  * `organizations/{organization-number}/locations/{region}`
  ///  * `folders/{folder-number}/locations/{region}`
  ///  * `projects/{project-id|project-number}/locations/{region}`
  /// @param entitlement  Required. The resource being created
  /// @param entitlement_id  Required. The ID to use for this entitlement. This becomes the last part of
  ///  the resource name.
  ///  @n
  ///  This value should be 4-63 characters in length, and valid characters are
  ///  "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
  ///  @n
  ///  This value should be unique among all other entitlements under the
  ///  specified `parent`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L702}
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  CreateEntitlement(
      std::string const& parent,
      google::cloud::privilegedaccessmanager::v1::Entitlement const&
          entitlement,
      std::string const& entitlement_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEntitlement
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEntitlement(
      NoAwaitTag, std::string const& parent,
      google::cloud::privilegedaccessmanager::v1::Entitlement const&
          entitlement,
      std::string const& entitlement_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new entitlement in a given project/folder/organization and
  /// location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L702}
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  CreateEntitlement(google::cloud::privilegedaccessmanager::v1::
                        CreateEntitlementRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEntitlement
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEntitlement(
      NoAwaitTag,
      google::cloud::privilegedaccessmanager::v1::
          CreateEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEntitlement
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  CreateEntitlement(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Deletes a single entitlement. This method can only be called when there
  /// are no in-progress (ACTIVE/ACTIVATING/REVOKING) grants under the
  /// entitlement.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L747}
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  DeleteEntitlement(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEntitlement
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEntitlement(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single entitlement. This method can only be called when there
  /// are no in-progress (ACTIVE/ACTIVATING/REVOKING) grants under the
  /// entitlement.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L747}
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  DeleteEntitlement(google::cloud::privilegedaccessmanager::v1::
                        DeleteEntitlementRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEntitlement
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEntitlement(
      NoAwaitTag,
      google::cloud::privilegedaccessmanager::v1::
          DeleteEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEntitlement
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  DeleteEntitlement(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Updates the entitlement specified in the request. Updated fields in the
  /// entitlement need to be specified in an update mask. The changes made to an
  /// entitlement are applicable only on future grants of the entitlement.
  /// However, if new approvers are added or existing approvers are removed from
  /// the approval workflow, the changes are effective on existing grants.
  ///
  /// The following fields are not supported for updates:
  ///
  ///  * All immutable fields
  ///  * Entitlement name
  ///  * Resource name
  ///  * Resource type
  ///  * Adding an approval workflow in an entitlement which previously had no
  ///    approval workflow.
  ///  * Deleting the approval workflow from an entitlement.
  ///  * Adding or deleting a step in the approval workflow (only one step is
  ///    supported)
  ///
  /// Note that updates are allowed on the list of approvers in an approval
  /// workflow step.
  ///
  /// @param entitlement  Required. The entitlement resource that is updated.
  /// @param update_mask  Required. The list of fields to update. A field is overwritten if, and only
  ///  if, it is in the mask. Any immutable fields set in the mask are ignored by
  ///  the server. Repeated fields and map fields are only allowed in the last
  ///  position of a `paths` string and overwrite the existing values. Hence an
  ///  update to a repeated field or a map should contain the entire list of
  ///  values. The fields specified in the update_mask are relative to the
  ///  resource and not to the request.
  ///  (e.g. `MaxRequestDuration`; *not* `entitlement.MaxRequestDuration`)
  ///  A value of '*' for this field refers to full replacement of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L778}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  UpdateEntitlement(
      google::cloud::privilegedaccessmanager::v1::Entitlement const&
          entitlement,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEntitlement
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEntitlement(
      NoAwaitTag,
      google::cloud::privilegedaccessmanager::v1::Entitlement const&
          entitlement,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the entitlement specified in the request. Updated fields in the
  /// entitlement need to be specified in an update mask. The changes made to an
  /// entitlement are applicable only on future grants of the entitlement.
  /// However, if new approvers are added or existing approvers are removed from
  /// the approval workflow, the changes are effective on existing grants.
  ///
  /// The following fields are not supported for updates:
  ///
  ///  * All immutable fields
  ///  * Entitlement name
  ///  * Resource name
  ///  * Resource type
  ///  * Adding an approval workflow in an entitlement which previously had no
  ///    approval workflow.
  ///  * Deleting the approval workflow from an entitlement.
  ///  * Adding or deleting a step in the approval workflow (only one step is
  ///    supported)
  ///
  /// Note that updates are allowed on the list of approvers in an approval
  /// workflow step.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Entitlement]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L380}
  /// [google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L778}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  UpdateEntitlement(google::cloud::privilegedaccessmanager::v1::
                        UpdateEntitlementRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEntitlement
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEntitlement(
      NoAwaitTag,
      google::cloud::privilegedaccessmanager::v1::
          UpdateEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEntitlement
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
  UpdateEntitlement(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Lists grants for a given entitlement.
  ///
  /// @param parent  Required. The parent resource which owns the grants.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.privilegedaccessmanager.v1.Grant], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  /// [google.cloud.privilegedaccessmanager.v1.ListGrantsRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1047}
  ///
  // clang-format on
  StreamRange<google::cloud::privilegedaccessmanager::v1::Grant> ListGrants(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists grants for a given entitlement.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.ListGrantsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.privilegedaccessmanager.v1.Grant], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  /// [google.cloud.privilegedaccessmanager.v1.ListGrantsRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1047}
  ///
  // clang-format on
  StreamRange<google::cloud::privilegedaccessmanager::v1::Grant> ListGrants(
      google::cloud::privilegedaccessmanager::v1::ListGrantsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// `SearchGrants` returns grants that are related to the calling user in the
  /// specified way.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.privilegedaccessmanager.v1.Grant], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  /// [google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1083}
  ///
  // clang-format on
  StreamRange<google::cloud::privilegedaccessmanager::v1::Grant> SearchGrants(
      google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Get details of a single grant.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Grant])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.GetGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1134}
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Grant> GetGrant(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details of a single grant.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.GetGrantRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Grant])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.GetGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1134}
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Grant> GetGrant(
      google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new grant in a given project and location.
  ///
  /// @param parent  Required. Name of the parent entitlement for which this grant is being
  ///  requested.
  /// @param grant  Required. The resource being created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Grant])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.CreateGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1191}
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Grant> CreateGrant(
      std::string const& parent,
      google::cloud::privilegedaccessmanager::v1::Grant const& grant,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new grant in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.CreateGrantRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Grant])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.CreateGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1191}
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Grant> CreateGrant(
      google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// `ApproveGrant` is used to approve a grant. This method can only be called
  /// on a grant when it's in the `APPROVAL_AWAITED` state. This operation can't
  /// be undone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.ApproveGrantRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Grant])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.ApproveGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1145}
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Grant> ApproveGrant(
      google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// `DenyGrant` is used to deny a grant. This method can only be called on a
  /// grant when it's in the `APPROVAL_AWAITED` state. This operation can't be
  /// undone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.DenyGrantRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.privilegedaccessmanager.v1.Grant])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.DenyGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1161}
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  ///
  // clang-format on
  StatusOr<google::cloud::privilegedaccessmanager::v1::Grant> DenyGrant(
      google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// `RevokeGrant` is used to immediately revoke access for a grant. This method
  /// can be called when the grant is in a non-terminal state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.privilegedaccessmanager.v1.RevokeGrantRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.privilegedaccessmanager.v1.Grant] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.privilegedaccessmanager.v1.Grant]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L799}
  /// [google.cloud.privilegedaccessmanager.v1.RevokeGrantRequest]: @googleapis_reference_link{google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto#L1177}
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>
  RevokeGrant(
      google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RevokeGrant
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RevokeGrant(
      NoAwaitTag,
      google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RevokeGrant
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>
  RevokeGrant(google::longrunning::Operation const& operation,
              Options opts = {});

 private:
  std::shared_ptr<PrivilegedAccessManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVILEGEDACCESSMANAGER_V1_PRIVILEGED_ACCESS_MANAGER_CLIENT_H
