// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcesettings/v1/resource_settings.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCESETTINGS_V1_INTERNAL_RESOURCE_SETTINGS_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCESETTINGS_V1_INTERNAL_RESOURCE_SETTINGS_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/resourcesettings/v1/resource_settings.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcesettings_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ResourceSettingsServiceStub {
 public:
  virtual ~ResourceSettingsServiceStub() = 0;

  virtual StatusOr<google::cloud::resourcesettings::v1::ListSettingsResponse>
  ListSettings(grpc::ClientContext& context, Options const& options,
               google::cloud::resourcesettings::v1::ListSettingsRequest const&
                   request) = 0;

  virtual StatusOr<google::cloud::resourcesettings::v1::Setting> GetSetting(
      grpc::ClientContext& context, Options const& options,
      google::cloud::resourcesettings::v1::GetSettingRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::resourcesettings::v1::Setting> UpdateSetting(
      grpc::ClientContext& context, Options const& options,
      google::cloud::resourcesettings::v1::UpdateSettingRequest const&
          request) = 0;
};

class DefaultResourceSettingsServiceStub : public ResourceSettingsServiceStub {
 public:
  explicit DefaultResourceSettingsServiceStub(
      std::unique_ptr<google::cloud::resourcesettings::v1::
                          ResourceSettingsService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::resourcesettings::v1::ListSettingsResponse>
  ListSettings(grpc::ClientContext& context, Options const& options,
               google::cloud::resourcesettings::v1::ListSettingsRequest const&
                   request) override;

  StatusOr<google::cloud::resourcesettings::v1::Setting> GetSetting(
      grpc::ClientContext& context, Options const& options,
      google::cloud::resourcesettings::v1::GetSettingRequest const& request)
      override;

  StatusOr<google::cloud::resourcesettings::v1::Setting> UpdateSetting(
      grpc::ClientContext& context, Options const& options,
      google::cloud::resourcesettings::v1::UpdateSettingRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::resourcesettings::v1::ResourceSettingsService::
                      StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcesettings_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCESETTINGS_V1_INTERNAL_RESOURCE_SETTINGS_STUB_H
